/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.util.logging.Logging;

public class ShapefileHeader {
    static final Logger LOGGER = Logging.getLogger(ShapefileHeader.class);
    public static final int MAGIC = 9994;
    public static final int VERSION = 1000;
    private int fileCode = -1;
    private int fileLength = -1;
    private int version = -1;
    private ShapeType shapeType = ShapeType.UNDEFINED;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    private void checkMagic(boolean strict) throws IOException {
        if (this.fileCode != 9994) {
            String message = "Wrong magic number, expected 9994, got " + this.fileCode;
            if (!strict) {
                LOGGER.info(message);
            } else {
                throw new IOException(message);
            }
        }
    }

    private void checkVersion(boolean strict) throws IOException {
        if (this.version != 1000) {
            String message = "Wrong version, expected 1000, got " + this.version;
            if (!strict) {
                LOGGER.info(message);
            } else {
                throw new IOException(message);
            }
        }
    }

    public void read(ByteBuffer file, boolean strict) throws IOException {
        file.order(ByteOrder.BIG_ENDIAN);
        this.fileCode = file.getInt();
        this.checkMagic(strict);
        file.position(file.position() + 20);
        this.fileLength = file.getInt();
        file.order(ByteOrder.LITTLE_ENDIAN);
        this.version = file.getInt();
        this.checkVersion(strict);
        this.shapeType = ShapeType.forID(file.getInt());
        this.minX = file.getDouble();
        this.minY = file.getDouble();
        this.maxX = file.getDouble();
        this.maxY = file.getDouble();
        file.order(ByteOrder.BIG_ENDIAN);
        file.position(file.position() + 32);
    }

    public void write(ByteBuffer file, ShapeType type, int numGeoms, int length, double minX, double minY, double maxX, double maxY) throws IOException {
        int i;
        file.order(ByteOrder.BIG_ENDIAN);
        file.putInt(9994);
        for (i = 0; i < 5; ++i) {
            file.putInt(0);
        }
        file.putInt(length);
        file.order(ByteOrder.LITTLE_ENDIAN);
        file.putInt(1000);
        file.putInt(type.id);
        file.putDouble(minX);
        file.putDouble(minY);
        file.putDouble(maxX);
        file.putDouble(maxY);
        file.order(ByteOrder.BIG_ENDIAN);
        for (i = 0; i < 8; ++i) {
            file.putInt(0);
        }
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public int getVersion() {
        return this.version;
    }

    public int getFileLength() {
        return this.fileLength;
    }

    public double minX() {
        return this.minX;
    }

    public double minY() {
        return this.minY;
    }

    public double maxX() {
        return this.maxX;
    }

    public double maxY() {
        return this.maxY;
    }

    public String toString() {
        return "ShapeFileHeader[ size " + this.fileLength + " version " + this.version + " shapeType " + String.valueOf((Object)this.shapeType) + " bounds " + this.minX + "," + this.minY + "," + this.maxX + "," + this.maxY + " ]";
    }
}

