/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.classifier;

import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.media.classifier.ColorMapTransform;
import org.eclipse.imagen.media.classifier.ColorMapTransformElement;
import org.eclipse.imagen.media.piecewise.GenericPiecewiseOpImage;
import org.eclipse.imagen.media.range.Range;

public class RasterClassifierOpImage<T extends ColorMapTransformElement>
extends GenericPiecewiseOpImage<T> {
    public static final String OPERATION_NAME = "RasterClassifier";

    public RasterClassifierOpImage(RenderedImage image, ColorMapTransform<T> lic, ImageLayout layout, Integer bandIndex, ROI roi, Range nodata, RenderingHints hints) {
        super(image, lic, RasterClassifierOpImage.prepareLayout(image, layout, lic), bandIndex, roi, nodata, RasterClassifierOpImage.prepareHints(hints), true);
        this.isByteData = false;
    }

    private static RenderingHints prepareHints(RenderingHints hints) {
        RenderingHints h = null;
        if (hints == null) {
            h = new RenderingHints(ImageN.KEY_TRANSFORM_ON_COLORMAP, false);
        } else {
            h = (RenderingHints)hints.clone();
            h.put(ImageN.KEY_TRANSFORM_ON_COLORMAP, (Object)false);
        }
        return h;
    }

    private static <T extends ColorMapTransformElement> ImageLayout prepareLayout(RenderedImage image, ImageLayout layout, ColorMapTransform<T> lic) {
        IndexColorModel finalColorModel = lic.getColorModel();
        SampleModel finalSampleModel = lic.getSampleModel(image.getWidth(), image.getHeight());
        if (layout == null) {
            layout = new ImageLayout();
        }
        layout.setColorModel((ColorModel)finalColorModel);
        layout.setSampleModel(finalSampleModel);
        return layout;
    }
}

