/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.DispatcherCallback;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class RestControllerAdvice
extends ResponseEntityExceptionHandler {
    static final Logger LOGGER = Logging.getLogger(RestControllerAdvice.class);

    private void notifyExceptionToCallbacks(WebRequest webRequest, HttpServletResponse response, Exception ex) {
        if (!(webRequest instanceof ServletWebRequest)) {
            return;
        }
        HttpServletRequest request = ((ServletWebRequest)webRequest).getRequest();
        this.notifyExceptionToCallbacks(request, response, ex);
    }

    private void notifyExceptionToCallbacks(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        List callbacks = GeoServerExtensions.extensions(DispatcherCallback.class);
        for (DispatcherCallback callback : callbacks) {
            callback.exception(request, response, ex);
        }
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public void handleResourceNotFound(ResourceNotFoundException e, HttpServletResponse response, WebRequest request, OutputStream os) throws IOException {
        String message;
        this.notifyExceptionToCallbacks(request, response, (Exception)e);
        boolean quietOnNotFound = this.isQuietOnNotFound(request);
        if (quietOnNotFound) {
            message = "";
        } else {
            message = this.message(e);
            LOGGER.log(Level.SEVERE, message, e);
        }
        response.setStatus(404);
        response.setContentType("text/plain");
        StreamUtils.copy((String)message, (Charset)StandardCharsets.UTF_8, (OutputStream)os);
    }

    @ExceptionHandler(value={RestException.class})
    public void handleRestException(RestException e, HttpServletResponse response, WebRequest request, OutputStream os) throws IOException {
        String message = this.message(e);
        LOGGER.log(Level.SEVERE, message, e);
        this.notifyExceptionToCallbacks(request, response, (Exception)e);
        if (e.getStatus().is4xxClientError()) {
            response.sendError(e.getStatus().value(), this.message(e));
        } else {
            response.setStatus(e.getStatus().value());
        }
        response.setContentType("text/plain");
        StreamUtils.copy((String)message, (Charset)StandardCharsets.UTF_8, (OutputStream)os);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public void handleGeneralException(Exception e, HttpServletRequest request, HttpServletResponse response, OutputStream os) throws Exception {
        if (Dispatcher.REQUEST.get() != null || e instanceof AuthenticationException || e instanceof AccessDeniedException) {
            throw e;
        }
        String message = this.message(e);
        LOGGER.log(Level.SEVERE, message, e);
        this.notifyExceptionToCallbacks(request, response, e);
        response.setStatus(500);
        response.setContentType("text/plain");
        StreamUtils.copy((String)message, (Charset)StandardCharsets.UTF_8, (OutputStream)os);
    }

    String message(Exception e) {
        if (e != null && e.getMessage() != null) {
            return e.getMessage();
        }
        return "";
    }

    private boolean isQuietOnNotFound(WebRequest request) {
        String parameter = request.getParameter("quietOnNotFound");
        return Boolean.parseBoolean(parameter) || this.quietOnNotFoundEnabled();
    }

    private boolean quietOnNotFoundEnabled() {
        return Optional.ofNullable((GeoServer)GeoServerExtensions.bean(GeoServer.class)).map(GeoServer::getGlobal).map(GeoServerInfo::getSettings).map(SettingsInfo::getMetadata).map(md -> (Boolean)md.get("quietOnNotFound", Boolean.class)).orElse(Boolean.FALSE);
    }
}

