/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SrsSyntax {
    EPSG_CODE("EPSG:"){

        @Override
        public String getSRS(String authority, String code) {
            return authority + ":" + code;
        }
    }
    ,
    AUTH_CODE("EPSG:"){

        @Override
        public String getSRS(String authority, String code) {
            return authority + ":" + code;
        }
    }
    ,
    OGC_HTTP_URL("http://www.opengis.net/gml/srs/epsg.xml#"){

        @Override
        public String getSRS(String authority, String code) {
            return "http://www.opengis.net/gml/srs/" + authority.toLowerCase() + ".xml#" + code;
        }
    }
    ,
    OGC_URN_EXPERIMENTAL("urn:x-ogc:def:crs:EPSG:"){

        @Override
        public String getSRS(String authority, String code) {
            return "urn:x-ogc:def:crs:" + authority + ":" + code;
        }
    }
    ,
    OGC_URN("urn:ogc:def:crs:EPSG::"){

        @Override
        public String getSRS(String authority, String code) {
            return "urn:ogc:def:crs:" + authority + "::" + code;
        }
    }
    ,
    OGC_HTTP_URI("http://www.opengis.net/def/crs/EPSG/0/"){

        @Override
        public String getSRS(String authority, String code) {
            return "http://www.opengis.net/def/crs/" + authority + "/0/" + code;
        }
    };

    private String prefix;

    private SrsSyntax(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public abstract String getSRS(String var1, String var2);

    public String getSRS(String identifier) {
        int idx = identifier.indexOf(":");
        if (idx == -1) {
            return this.getSRS("EPSG", identifier);
        }
        return this.getSRS(identifier.substring(0, idx), identifier.substring(idx + 1));
    }
}

