/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;

public class GeoServerNodeData {
    public static final String GEOSERVER_NODE_OPTS = "GEOSERVER_NODE_OPTS";
    static final Logger LOGGER = Logging.getLogger(GeoServerNodeData.class);
    final String nodeId;
    final Map<String, String> nodeIdStyle;
    static final Map<String, Function<InetAddress, String>> SUBSTITUTIONS;
    private static InetAddress mockAddress;

    public GeoServerNodeData(String nodeId, Map<String, String> nodeIdStyle) {
        this.nodeId = nodeId;
        this.nodeIdStyle = nodeIdStyle;
    }

    public static GeoServerNodeData createFromString(String nodeOpts) {
        String nodeId = null;
        LinkedHashMap<String, String> nodeIdStyle = new LinkedHashMap<String, String>();
        if (nodeOpts != null) {
            try {
                String color;
                Map<String, String> options = GeoServerNodeData.parseProperties(nodeOpts);
                String id = options.get("id");
                if (id != null) {
                    if (SUBSTITUTIONS.keySet().stream().anyMatch(id::contains)) {
                        InetAddress address = GeoServerNodeData.getLocalHostLANAddress();
                        for (Map.Entry<String, Function<InetAddress, String>> e : SUBSTITUTIONS.entrySet()) {
                            String token = "$%s".formatted(e.getKey());
                            String value = e.getValue().apply(address);
                            id = id.replace(token, value);
                        }
                    }
                }
                nodeId = id;
                String bgcolor = options.get("background");
                if (bgcolor != null) {
                    nodeIdStyle.put("backgroundColor", bgcolor);
                }
                if ((color = options.get("color")) != null) {
                    nodeIdStyle.put("color", color);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to parse GEOSERVER_NODE_OPTS, expected syntax is id:<nodeid>;color:<css_color>, but got " + nodeOpts + " instead. Disabling NODE_ID GUI element");
                nodeId = null;
                nodeIdStyle.clear();
            }
        }
        return new GeoServerNodeData(nodeId, nodeIdStyle);
    }

    public static GeoServerNodeData createFromEnvironment() {
        return GeoServerNodeData.createFromString(GeoServerExtensions.getProperty((String)GEOSERVER_NODE_OPTS));
    }

    @VisibleForTesting
    static void setMockAddress(InetAddress mockAddress) {
        GeoServerNodeData.mockAddress = mockAddress;
    }

    @VisibleForTesting
    static void clearMockAddress() {
        mockAddress = null;
    }

    static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        if (Objects.nonNull(mockAddress)) {
            return mockAddress;
        }
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> inetAddrs = ni.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address");
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    private static Map<String, String> parseProperties(String property) {
        HashMap<String, String> properties = new HashMap<String, String>();
        List kvps = KvpUtils.escapedTokens((String)property, (char)';');
        for (String kvp : kvps) {
            List kv = KvpUtils.escapedTokens((String)kvp, (char)':', (int)2);
            String key = ((String)kv.get(0)).toLowerCase();
            String value = kv.size() == 1 ? "true" : KvpUtils.unescape((String)((String)kv.get(1)));
            properties.put(key, value);
        }
        return properties;
    }

    public String getId() {
        return this.nodeId;
    }

    public Map<String, String> getIdStyle() {
        return this.nodeIdStyle;
    }

    static {
        HashMap<String, Function<InetAddress, String>> subs = new HashMap<String, Function<InetAddress, String>>();
        subs.put("host_ip", InetAddress::getHostAddress);
        subs.put("host_name", InetAddress::getHostName);
        subs.put("host_short_name", addr -> {
            String name = addr.getHostName();
            return name.split("\\.")[0];
        });
        subs.put("host_compact_name", addr -> {
            String name = addr.getHostName();
            String[] parts = name.split("\\.");
            String hostName = parts[0];
            return Streams.concat((Stream[])new Stream[]{Stream.of(hostName), Arrays.stream(parts).skip(1L).map(p -> p.substring(0, 1))}).collect(Collectors.joining("."));
        });
        SUBSTITUTIONS = Collections.unmodifiableMap(subs);
    }
}

