/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import com.google.common.collect.Lists;
import java.awt.RenderingHints;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationRegistry;
import org.eclipse.imagen.RegistryElementDescriptor;
import org.eclipse.imagen.RegistryMode;
import org.eclipse.imagen.TileCache;
import org.eclipse.imagen.media.ConcurrentOperationRegistry;
import org.eclipse.imagen.media.cache.ConcurrentTileCacheMultiMap;
import org.eclipse.imagen.util.ImagingListener;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.util.WeakCollectionCleaner;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.Logging;

public class GeoserverInitStartupListener
implements ServletContextListener {
    static final String COM_SUN_JPEG2000_PACKAGE = "com.sun.media.imageioimpl.plugins.jpeg2000";
    private static Logger LOGGER;
    boolean relinquishLoggingControl;
    private static final String COMPARISON_TOLERANCE_PROPERTY = "COMPARISON_TOLERANCE";
    private static final double DEFAULT_COMPARISON_TOLERANCE = 1.0E-8;

    public void contextInitialized(ServletContextEvent sce) {
        double comparisonTolerance;
        block8: {
            if (System.getProperty("jts.overlay") == null) {
                System.setProperty("jts.overlay", "ng");
            }
            LoggingUtils.GeoToolsLoggingRedirection policy = this.establishLoggingRedirectionPolicy(sce.getServletContext());
            LOGGER = Logging.getLogger((String)"org.geoserver.logging");
            LOGGER.config("Logging policy: " + String.valueOf((Object)policy));
            GeoTools.init((Hints)null);
            GeoserverInitStartupListener.initImageNDefaultInstance();
            ImageN imagen = ImageN.getDefaultInstance();
            if (!(imagen.getOperationRegistry() instanceof ConcurrentOperationRegistry)) {
                imagen.setOperationRegistry(ConcurrentOperationRegistry.initializeRegistry());
            }
            if (!(imagen.getTileCache() instanceof ConcurrentTileCacheMultiMap)) {
                imagen.setTileCache((TileCache)new ConcurrentTileCacheMultiMap());
            }
            String strValue = GeoServerExtensions.getProperty((String)"RELINQUISH_LOG4J_CONTROL", (ServletContext)sce.getServletContext());
            this.relinquishLoggingControl = Boolean.valueOf(strValue);
            if (System.getProperty("org.geotools.referencing.forceXY") == null) {
                System.setProperty("org.geotools.referencing.forceXY", "true");
            }
            if (Boolean.TRUE.equals(Hints.getSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER))) {
                Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING, (Object)"http");
            }
            Hints.putSystemDefault((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)true);
            String comparisonToleranceProperty = GeoServerExtensions.getProperty((String)COMPARISON_TOLERANCE_PROPERTY);
            comparisonTolerance = 1.0E-8;
            if (comparisonToleranceProperty != null) {
                try {
                    comparisonTolerance = Double.parseDouble(comparisonToleranceProperty);
                }
                catch (NumberFormatException nfe) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block8;
                    LOGGER.warning("Unable to parse the specified COMPARISON_TOLERANCE system property: " + comparisonToleranceProperty + " which should be a number. Using Default: 1.0E-8");
                }
            }
        }
        Hints.putSystemDefault((RenderingHints.Key)Hints.COMPARISON_TOLERANCE, (Object)comparisonTolerance);
        Hints defHints = GeoTools.getDefaultHints();
        Hints.putSystemDefault((RenderingHints.Key)Hints.GRID_COVERAGE_FACTORY, (Object)CoverageFactoryFinder.getGridCoverageFactory((Hints)defHints));
        System.setProperty("org.geotools.epsg.factory.timeout", "-1");
        System.setProperty("java.util.prefs.syncInterval", "5000000");
        ImageIO.scanForPlugins();
        this.unregisterImageIOJpeg2000Support(ImageReaderSpi.class);
        this.unregisterImageIOJpeg2000Support(ImageWriterSpi.class);
        Hints.putSystemDefault((RenderingHints.Key)Hints.FILTER_FACTORY, (Object)CommonFactoryFinder.getFilterFactory(null));
        Hints.putSystemDefault((RenderingHints.Key)Hints.STYLE_FACTORY, (Object)CommonFactoryFinder.getStyleFactory(null));
        Hints.putSystemDefault((RenderingHints.Key)Hints.FEATURE_FACTORY, (Object)CommonFactoryFinder.getFeatureFactory(null));
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        Hints.putSystemDefault((RenderingHints.Key)Hints.EXECUTOR_SERVICE, (Object)executor);
    }

    public static void initImageNDefaultInstance() {
        ImageN imagen = ImageN.getDefaultInstance();
        if (!(imagen.getImagingListener() instanceof GeoServerImagingListener)) {
            imagen.setImagingListener((ImagingListener)new GeoServerImagingListener());
        }
    }

    private <T extends ImageReaderWriterSpi> void unregisterImageIOJpeg2000Support(Class<T> category) {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<T> it = registry.getServiceProviders(category, false);
        ArrayList providers = Lists.newArrayList(it);
        for (ImageReaderWriterSpi spi : providers) {
            if (!COM_SUN_JPEG2000_PACKAGE.equals(spi.getClass().getPackage().getName())) continue;
            registry.deregisterServiceProvider(spi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        try {
            LOGGER.info("Beginning GeoServer cleanup sequence");
            ClassLoader webappClassLoader = this.getClass().getClassLoader();
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            HashSet<Object> driversToUnload = new HashSet<Object>();
            while (drivers.hasMoreElements()) {
                Driver driver = drivers.nextElement();
                try {
                    ClassLoader classLoader = driver.getClass().getClassLoader();
                    if (classLoader == null || !classLoader.equals(webappClassLoader)) continue;
                    driversToUnload.add(driver);
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.SEVERE, "", throwable);
                }
            }
            for (Driver driver : driversToUnload) {
                try {
                    DriverManager.deregisterDriver(driver);
                    LOGGER.fine("Unregistered JDBC driver " + String.valueOf(driver));
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Could now unload driver " + String.valueOf(driver.getClass()), e);
                }
            }
            try {
                Class<?> h2Driver = Class.forName("org.h2.Driver");
                Method method = h2Driver.getMethod("unload", new Class[0]);
                method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException notIncluded) {
                if ("org.h2.Driver".equalsIgnoreCase(notIncluded.getMessage())) {
                    LOGGER.log(Level.FINE, "H2 driver not included, skipping unload");
                } else {
                    LOGGER.log(Level.WARNING, "Failed to unload the H2 driver", notIncluded);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to unload the H2 driver", e);
            }
            try {
                this.disposeAuthorityFactories(ReferencingFactoryFinder.getCoordinateOperationAuthorityFactories(null));
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Error occurred trying to dispose authority factories", e);
            }
            try {
                this.disposeAuthorityFactories(ReferencingFactoryFinder.getCRSAuthorityFactories(null));
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Error occurred trying to dispose authority factories", e);
            }
            try {
                this.disposeAuthorityFactories(ReferencingFactoryFinder.getCSAuthorityFactories(null));
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Error occurred trying to dispose authority factories", e);
            }
            WeakCollectionCleaner.DEFAULT.exit();
            DeferredAuthorityFactory.exit();
            CRS.reset((String)"all");
            LOGGER.fine("Shut down GT referencing threads ");
            ReferencingFactoryFinder.reset();
            CommonFactoryFinder.reset();
            DataStoreFinder.reset();
            DataAccessFinder.reset();
            LOGGER.fine("Shut down GT  SPI ");
            LOGGER.fine("Shut down coverage thread pool ");
            Object o = Hints.getSystemDefault((RenderingHints.Key)Hints.EXECUTOR_SERVICE);
            if (o != null && o instanceof ExecutorService) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)o;
                try {
                    threadPoolExecutor.shutdown();
                }
                finally {
                    threadPoolExecutor.shutdownNow();
                }
            }
            IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
            HashSet<IIOServiceProvider> providersToUnload = new HashSet<IIOServiceProvider>();
            Iterator<Class<Object>> cats = iIORegistry.getCategories();
            while (cats.hasNext()) {
                Class<?> clazz = cats.next();
                Iterator<?> it = iIORegistry.getServiceProviders(clazz, false);
                while (it.hasNext()) {
                    IIOServiceProvider provider = (IIOServiceProvider)it.next();
                    if (!webappClassLoader.equals(provider.getClass().getClassLoader())) continue;
                    providersToUnload.add(provider);
                }
            }
            for (IIOServiceProvider iIOServiceProvider : providersToUnload) {
                iIORegistry.deregisterServiceProvider(iIOServiceProvider);
                LOGGER.fine("Unregistering Image I/O provider " + String.valueOf(iIOServiceProvider));
            }
            OperationRegistry opRegistry = ImageN.getDefaultInstance().getOperationRegistry();
            for (String mode : RegistryMode.getModeNames()) {
                Iterator descriptors = opRegistry.getDescriptors(mode).iterator();
                while (descriptors != null && descriptors.hasNext()) {
                    RegistryElementDescriptor red = (RegistryElementDescriptor)descriptors.next();
                    int factoryCount = 0;
                    int unregisteredCount = 0;
                    Iterator factories = opRegistry.getFactoryIterator(mode, red.getName());
                    while (factories != null && factories.hasNext()) {
                        Object factory = factories.next();
                        if (factory == null) continue;
                        ++factoryCount;
                        if (!webappClassLoader.equals(factory.getClass().getClassLoader())) continue;
                        boolean unregistered = false;
                        Vector orderedProductList = opRegistry.getOrderedProductList(mode, red.getName());
                        if (orderedProductList != null) {
                            Iterator products = orderedProductList.iterator();
                            while (products != null && products.hasNext()) {
                                String product = (String)products.next();
                                try {
                                    opRegistry.unregisterFactory(mode, red.getName(), product, factory);
                                    LOGGER.fine("Unregistering ImageN factory " + String.valueOf(factory.getClass()));
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        if (!unregistered) continue;
                        ++unregisteredCount;
                    }
                    if (factoryCount <= 0 || unregisteredCount != factoryCount) continue;
                    opRegistry.unregisterDescriptor(red);
                }
            }
            Introspector.flushCaches();
            LOGGER.fine("Cleaned up javabean caches");
            if (!this.relinquishLoggingControl) {
                LogManager.shutdown();
            }
            LogFactory.release((ClassLoader)Thread.currentThread().getContextClassLoader());
            try {
                System.gc();
                System.runFinalization();
                System.gc();
                System.runFinalization();
                System.gc();
                System.runFinalization();
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.SEVERE, "Failed to perform closing up finalization", throwable);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "", t);
        }
    }

    public static String getProperty(String propertyName, ServletContext context) {
        String property = System.getProperty(propertyName);
        if (context != null && property == null) {
            property = context.getInitParameter(propertyName);
        }
        if (property == null) {
            property = System.getenv(propertyName);
        }
        return property;
    }

    LoggingUtils.GeoToolsLoggingRedirection establishLoggingRedirectionPolicy(ServletContext context) {
        LoggingUtils.GeoToolsLoggingRedirection policy = LoggingUtils.GeoToolsLoggingRedirection.findValue(GeoserverInitStartupListener.getProperty("GT2_LOGGING_REDIRECTION", context));
        try {
            switch (policy) {
                case JavaLogging: {
                    Logging.ALL.setLoggerFactory((LoggerFactory)null);
                    break;
                }
                case Logback: {
                    Logging.ALL.setLoggerFactory("org.geotools.util.logging.LogbackLoggerFactory");
                    break;
                }
                case Log4J2: {
                    Logging.ALL.setLoggerFactory("org.geotools.util.logging.Log4J2LoggerFactory");
                    break;
                }
                case CommonsLogging: {
                    Logging.ALL.setLoggerFactory("org.geotools.util.logging.CommonsLoggerFactory");
                    break;
                }
                case Log4J: {
                    Logging.ALL.setLoggerFactory("org.geotools.util.logging.Log4JLoggerFactory");
                }
            }
        }
        catch (Exception e) {
            Logging.ALL.setLoggerFactory((LoggerFactory)null);
            Logging.getLogger((String)"org.geoserver.logging").log(Level.SEVERE, "Could not configure log4j logging redirection: '" + String.valueOf((Object)policy) + "'", e);
            return null;
        }
        return policy;
    }

    private void disposeAuthorityFactories(Set<? extends AuthorityFactory> factories) throws FactoryException {
        for (AuthorityFactory authorityFactory : factories) {
            if (!(authorityFactory instanceof AbstractAuthorityFactory)) continue;
            AbstractAuthorityFactory factory = (AbstractAuthorityFactory)authorityFactory;
            LOGGER.fine("Disposing referencing factory " + String.valueOf(authorityFactory));
            factory.dispose();
        }
    }

    private static final class GeoServerImagingListener
    implements ImagingListener {
        private static final Logger LOGGER = Logging.getLogger((String)"org.eclipse.imagen");

        private GeoServerImagingListener() {
        }

        public boolean errorOccurred(String message, Throwable thrown, Object where, boolean isRetryable) throws RuntimeException {
            if (message.contains("Continuing in pure Java mode")) {
                LOGGER.log(Level.FINE, message, thrown);
            } else {
                if (thrown instanceof RuntimeException) {
                    RuntimeException exception = (RuntimeException)thrown;
                    if (!(where instanceof OperationRegistry)) {
                        throw exception;
                    }
                }
                LOGGER.log(Level.INFO, message, thrown);
            }
            return false;
        }
    }
}

