/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import org.geoserver.catalog.FeatureTypeCallback;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geotools.api.data.DataAccess;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.internal.v2_0.storedquery.StoredQueryConfiguration;

public class CascadedStoredQueryCallback
implements FeatureTypeCallback {
    @Override
    public boolean canHandle(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess) {
        return dataAccess instanceof WFSDataStore && info.getMetadata() != null && info.getMetadata().get("WFS_NG_STORED_QUERY_CONFIGURATION") instanceof StoredQueryConfiguration;
    }

    @Override
    public boolean initialize(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess, Name temporaryName) throws IOException {
        StoredQueryConfiguration sqc = info.getMetadata().get("WFS_NG_STORED_QUERY_CONFIGURATION", StoredQueryConfiguration.class);
        WFSDataStore wstore = (WFSDataStore)dataAccess;
        String localPart = info.getName();
        boolean usesTemporary = false;
        if (temporaryName != null) {
            localPart = temporaryName.getLocalPart();
            usesTemporary = true;
        }
        if (!wstore.getConfiguredStoredQueries().containsValue(localPart)) {
            wstore.addStoredQuery(localPart, sqc.getStoredQueryId());
        }
        return usesTemporary;
    }

    @Override
    public void flush(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess) throws IOException {
    }

    @Override
    public void dispose(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess, Name temporaryName) throws IOException {
        WFSDataStore wstore = (WFSDataStore)dataAccess;
        wstore.removeStoredQuery(temporaryName.getLocalPart());
    }
}

