/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.media.mosaic.MosaicDescriptor;
import org.eclipse.imagen.media.range.NoDataContainer;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.range.RangeInt;
import org.eclipse.imagen.media.utilities.ImageLayout2;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.CoverageViewHandler;
import org.geoserver.catalog.CoverageViewReader;
import org.geoserver.data.util.CoverageUtils;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;

class CoverageViewComposer {
    private final CoverageViewHandler handler;
    private final GridCoverageFactory coverageFactory;
    private final HashMap<String, GridCoverage2D> inputCoverages = new HashMap();
    private final HashMap<String, FillingLayout> noDataCoverages = new HashMap();
    private final HashMap<String, GridCoverage2DReader> inputReaders = new HashMap();
    private int nonNullCoverages;
    private GridCoverage2D dynamicAlphaSource;
    private boolean fillMissingBands;

    public CoverageViewComposer(boolean fillMissingBands, CoverageViewHandler handler, GridCoverageFactory coverageFactory) {
        this.fillMissingBands = fillMissingBands;
        this.handler = handler;
        this.coverageFactory = coverageFactory;
    }

    public boolean containsCoverage(String coverageName) {
        return this.inputCoverages.containsKey(coverageName);
    }

    public void putReader(String coverageName, GridCoverage2DReader reader) {
        this.inputReaders.put(coverageName, reader);
    }

    public Set<String> getCoverageNames() {
        return this.inputReaders.keySet();
    }

    public GridCoverage2DReader getReader(String coverageName) {
        return this.inputReaders.get(coverageName);
    }

    public CoverageViewReader.ViewInputs prepareViewInputs(List<CoverageView.CoverageBand> bands) {
        return new CoverageViewReader.ViewInputs(bands, this.inputReaders, this.inputCoverages, this.dynamicAlphaSource, this.nonNullCoverages);
    }

    boolean shouldProcessCoverage(String coverageName, GridCoverage2DReader reader, GridCoverage2D coverage) throws IOException {
        if (coverage != null) {
            ++this.nonNullCoverages;
            if (this.dynamicAlphaSource == null && this.hasDynamicAlpha(coverage, reader)) {
                this.dynamicAlphaSource = coverage;
            }
            this.inputCoverages.put(coverageName, coverage);
            return true;
        }
        if (!this.handler.isHomogeneousCoverages() && this.handler.getEnvelopeCompositionType() != CoverageView.EnvelopeCompositionType.INTERSECTION) {
            return true;
        }
        if (!this.fillMissingBands) {
            return false;
        }
        FillingLayout fillingLayout = this.getFillingLayout(reader, coverageName);
        if (fillingLayout == null) {
            return false;
        }
        this.noDataCoverages.put(coverageName, fillingLayout);
        return true;
    }

    boolean canCompose() {
        if (this.inputCoverages.isEmpty()) {
            return false;
        }
        int coveragesSize = this.getCoverageNames().size();
        int missingCoverages = coveragesSize - this.inputCoverages.size();
        if (missingCoverages == 0) {
            return true;
        }
        if (!this.fillMissingBands) {
            return false;
        }
        if (!this.noDataCoverages.isEmpty() && this.noDataCoverages.size() == missingCoverages) {
            GridCoverage2D referenceCoverage = this.inputCoverages.values().iterator().next();
            GridGeometry2D gridGeometry = referenceCoverage.getGridGeometry();
            GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
            ReferencedEnvelope envelope = referenceCoverage.getEnvelope2D();
            RenderedImage refImage = referenceCoverage.getRenderedImage();
            RangeInt zeroRange = RangeFactory.create((int)0, (int)0);
            for (Map.Entry<String, FillingLayout> entry : this.noDataCoverages.entrySet()) {
                String coverageName = entry.getKey();
                FillingLayout fillingLayout = entry.getValue();
                double noDataValue = fillingLayout.noData;
                ImageLayout2 il = this.prepareImageLayout(refImage, gridRange, fillingLayout);
                RenderingHints renderingHints = new RenderingHints(ImageN.KEY_IMAGE_LAYOUT, il);
                double threshold = CoverageUtilities.getMosaicThreshold((int)il.getSampleModel(null).getDataType());
                ImageWorker w = new ImageWorker(renderingHints);
                w.setBackground(new double[]{noDataValue});
                w.mosaic(new RenderedImage[0], MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])new double[][]{{threshold}}, new Range[]{zeroRange});
                RenderedImage image = w.getRenderedImage();
                GridCoverage2D noDataCoverage = this.coverageFactory.create((CharSequence)coverageName, image, (Bounds)envelope, referenceCoverage.getSampleDimensions(), null, null);
                this.inputCoverages.put(coverageName, noDataCoverage);
            }
            if (coveragesSize == this.inputCoverages.size()) {
                return true;
            }
        }
        return false;
    }

    private ImageLayout2 prepareImageLayout(RenderedImage refImage, GridEnvelope2D gridRange, FillingLayout fillingLayout) {
        ImageLayout2 il = new ImageLayout2();
        int width = gridRange.width;
        int height = gridRange.height;
        int tileHeight = refImage.getTileHeight();
        int tileWidth = refImage.getTileWidth();
        int minX = refImage.getMinX();
        int minY = refImage.getMinY();
        ColorModel cm = fillingLayout.imageLayout.getColorModel(null);
        SampleModel sm = fillingLayout.imageLayout.getSampleModel(null);
        il.setColorModel(cm);
        il.setTileHeight(tileHeight);
        il.setTileWidth(tileWidth);
        il.setMinX(minX);
        il.setMinY(minY);
        il.setWidth(width);
        il.setHeight(height);
        il.setSampleModel(sm.createCompatibleSampleModel(width, height));
        return il;
    }

    private boolean hasDynamicAlpha(GridCoverage2D coverage, GridCoverage2DReader reader) throws IOException {
        if (coverage == null) {
            return false;
        }
        ColorModel dynamicCm = coverage.getRenderedImage().getColorModel();
        if (!dynamicCm.hasAlpha() || !this.hasAlphaBand(dynamicCm)) {
            return false;
        }
        ImageLayout readerLayout = reader.getImageLayout();
        if (readerLayout == null) {
            return false;
        }
        ColorModel nativeCm = readerLayout.getColorModel(null);
        if (nativeCm == null || nativeCm.hasAlpha()) {
            return false;
        }
        return !this.hasAlphaBand(nativeCm);
    }

    private boolean hasAlphaBand(ColorModel cm) {
        return cm.getNumComponents() == 2 && cm.getNumColorComponents() == 1 || cm.getNumComponents() == 4 && cm.getNumColorComponents() == 3;
    }

    private FillingLayout getFillingLayout(GridCoverage2DReader reader, String coverageName) throws IOException {
        NoDataContainer noDataContainer;
        GridCoverage2D gc;
        FillingLayout info = null;
        Format format = reader.getFormat();
        ParameterValueGroup readParams = format.getReadParameters();
        Map<String, Serializable> parameters = CoverageUtils.getParametersKVP(readParams);
        try {
            gc = CoverageUtils.readSampleGridCoverage(reader, readParams, parameters, null, true);
        }
        catch (TransformException e) {
            throw new IOException("Exception occurred reading the sample coverage", e);
        }
        if (gc != null && (noDataContainer = CoverageUtilities.getNoDataProperty((GridCoverage2D)gc)) != null) {
            ImageLayout imageLayout = reader.getImageLayout(coverageName);
            info = new FillingLayout(noDataContainer.getAsSingleValue(), imageLayout);
            gc.dispose(true);
            if (gc.getRenderedImage() instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)gc.getRenderedImage()));
            }
        }
        return info;
    }

    static class FillingLayout {
        private Double noData;
        private ImageLayout imageLayout;

        public FillingLayout(Double noData, ImageLayout imageLayout) {
            this.noData = noData;
            this.imageLayout = imageLayout;
        }
    }
}

