/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import it.geosolutions.imageio.maskband.DatasetLayout;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.NotAColorSpace;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RasterFactory;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.jiffleop.JiffleDescriptor;
import org.eclipse.imagen.media.range.NoDataContainer;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.utilities.ImageLayout2;
import org.eclipse.imagen.operator.ConstantDescriptor;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.CoverageViewComposer;
import org.geoserver.catalog.CoverageViewHandler;
import org.geoserver.catalog.CoverageViewPamResourceInfo;
import org.geoserver.catalog.SingleGridCoverage2DReader;
import org.geoserver.catalog.StructuredCoverageViewReader;
import org.geotools.api.coverage.SampleDimensionType;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.coverage.grid.GridCoverageWriter;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.PAMResourceInfo;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.GridCoverage2DRIA;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.DefaultResourceInfo;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.NumberRange;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class CoverageViewReader
implements GridCoverage2DReader {
    private static final int HETEROGENEOUS_RASTER_GUTTER = 10;
    public static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    private static final Logger LOGGER = Logging.getLogger(CoverageViewReader.class);
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    CoverageView coverageView;
    private CoverageViewHandler handler;
    String referenceName;
    private String coverageName;
    private GridCoverage2DReader delegate;
    private Hints hints;
    private GridCoverageFactory coverageFactory;
    private ImageLayout imageLayout;

    public CoverageViewReader(GridCoverage2DReader delegate, CoverageView coverageView, CoverageInfo coverageInfo, Hints hints) {
        Object factory;
        this.coverageName = coverageView.getName();
        this.delegate = delegate;
        this.coverageView = coverageView;
        this.hints = hints;
        this.referenceName = coverageView.getBand(0).getInputCoverageBands().get(0).getCoverageName();
        this.handler = new CoverageViewHandler(delegate, this.referenceName, coverageView);
        if (this.hints != null && this.hints.containsKey((Object)Hints.GRID_COVERAGE_FACTORY) && (factory = this.hints.get((Object)Hints.GRID_COVERAGE_FACTORY)) != null && factory instanceof GridCoverageFactory) {
            GridCoverageFactory gridCoverageFactory;
            this.coverageFactory = gridCoverageFactory = (GridCoverageFactory)factory;
        }
        if (this.coverageFactory == null) {
            this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        }
        try {
            ImageLayout layout = delegate.getImageLayout(this.referenceName);
            SampleModel originalSampleModel = layout.getSampleModel(null);
            SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)originalSampleModel.getDataType(), (int)originalSampleModel.getWidth(), (int)originalSampleModel.getHeight(), (int)coverageView.getCoverageBands().size());
            ColorModel colorModel = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
            this.imageLayout = new ImageLayout2(layout.getMinX(null), layout.getMinY(null), originalSampleModel.getWidth(), originalSampleModel.getHeight());
            this.imageLayout.setSampleModel(sampleModel);
            this.imageLayout.setColorModel(colorModel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GridCoverage2D read(GeneralParameterValue ... parameters) throws IllegalArgumentException, IOException {
        Optional<Object> ggParameter = Optional.empty();
        if (parameters != null && parameters.length > 0) {
            ggParameter = Arrays.stream(parameters).filter(parameter -> this.matches((GeneralParameterValue)parameter, (ParameterDescriptor<?>)AbstractGridFormat.READ_GRIDGEOMETRY2D)).findFirst();
        }
        GridGeometry2D requestedGridGeometry = null;
        if (ggParameter.isPresent()) {
            ReferencedEnvelope dataEnvelope;
            ParameterValue value = (ParameterValue)ggParameter.get();
            requestedGridGeometry = (GridGeometry2D)value.getValue();
            ReferencedEnvelope requestedEnvelope = ReferencedEnvelope.reference((Bounds)requestedGridGeometry.getEnvelope());
            if (CRS.equalsIgnoreMetadata((Object)requestedEnvelope, (Object)(dataEnvelope = ReferencedEnvelope.reference((Bounds)this.handler.getOriginalEnvelope())))) {
                if (!requestedEnvelope.intersects((BoundingBox)dataEnvelope)) {
                    return null;
                }
            } else {
                try {
                    ReferencedEnvelope re84 = requestedEnvelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                    ReferencedEnvelope de84 = dataEnvelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                    if (!re84.intersects((BoundingBox)de84)) {
                        return null;
                    }
                }
                catch (FactoryException | TransformException e) {
                    LOGGER.log(Level.FINE, "Cannot determine if the requested BBOX intersects the data one, continuing", e);
                }
            }
            if (!this.handler.isHomogeneousCoverages()) {
                GridEnvelope2D range = requestedGridGeometry.getGridRange2D();
                GridEnvelope2D expandedRange = new GridEnvelope2D((int)range.getMinX() - 10, (int)range.getMinY() - 10, (int)range.getWidth() + 20, (int)range.getHeight() + 20);
                GridGeometry2D expandedGG = new GridGeometry2D((GridEnvelope)expandedRange, requestedGridGeometry.getGridToCRS(), requestedGridGeometry.getCoordinateReferenceSystem());
                value.setValue((Object)expandedGG);
            }
        }
        List<CoverageView.CoverageBand> bands = this.coverageView.getCoverageBands();
        CoverageView.CompositionType compositionType = this.coverageView.getCompositionType();
        if (compositionType == null) {
            compositionType = CoverageView.CompositionType.BAND_SELECT;
        }
        CoverageViewHandler.CoveragesConsistencyChecker checker = null;
        ArrayList<Integer> selectedBandIndices = CoverageViewReader.getBandIndices(parameters, bands);
        boolean fillMissingBands = Boolean.TRUE.equals(this.coverageView.getFillMissingBands());
        ViewInputs inputAlphaNonNull = this.getInputAlphaNonNullCoverages(parameters, selectedBandIndices, bands, checker, true, compositionType, fillMissingBands);
        if (inputAlphaNonNull == null) {
            return null;
        }
        if (inputAlphaNonNull.nonNullCoverages == 0 || inputAlphaNonNull.inputCoverages.isEmpty()) {
            return null;
        }
        if (compositionType == CoverageView.CompositionType.BAND_SELECT) {
            return this.readUsingBandSelect(inputAlphaNonNull, bands, selectedBandIndices, requestedGridGeometry);
        }
        if (compositionType == CoverageView.CompositionType.JIFFLE) {
            return this.readUsingJiffle(inputAlphaNonNull);
        }
        throw new UnsupportedOperationException("Unsupported composition type: " + String.valueOf((Object)compositionType));
    }

    public GridCoverage2D readUsingBandSelect(ViewInputs inputAlphaNonNull, List<CoverageView.CoverageBand> bands, ArrayList<Integer> selectedBandIndices, GridGeometry2D requestedGridGeometry) throws IOException {
        GridCoverage2D result;
        int index;
        ArrayList<GridCoverage2D> coverages = new ArrayList<GridCoverage2D>();
        if (inputAlphaNonNull.nonNullCoverages < inputAlphaNonNull.inputCoverages.size()) {
            float height;
            float width;
            if (requestedGridGeometry != null) {
                GridEnvelope2D range = requestedGridGeometry.getGridRange2D();
                width = (float)range.getWidth();
                height = (float)range.getHeight();
            } else {
                GridCoverage2D reference = inputAlphaNonNull.inputCoverages.values().stream().filter(c -> c != null).findFirst().get();
                RenderedImage ri = reference.getRenderedImage();
                width = ri.getWidth();
                height = ri.getHeight();
            }
            for (String name : inputAlphaNonNull.inputCoverages.keySet()) {
                SingleGridCoverage2DReader reader = SingleGridCoverage2DReader.wrap(this.delegate, name);
                ImageLayout layout = reader.getImageLayout();
                int numBands = layout.getSampleModel(null).getNumBands();
                Object[] bandValues = new Number[numBands];
                Arrays.fill(bandValues, (Object)0.0);
                ConstantDescriptor.create((Float)Float.valueOf(width), (Float)Float.valueOf(height), (Number[])bandValues, (RenderingHints)new RenderingHints(ImageN.KEY_IMAGE_LAYOUT, layout));
            }
        }
        ArrayList<CoverageView.CoverageBand> mergedBands = CoverageViewReader.getMergedBands(selectedBandIndices, bands);
        int transformationChoice = index = 0;
        CoverageViewHandler.CoverageResolutionChooser resolutionChooser = this.handler.getCoverageResolutionChooser();
        for (CoverageView.CoverageBand band : mergedBands) {
            List<CoverageView.InputCoverageBand> selectedBands = band.getInputCoverageBands();
            String coverageName = selectedBands.get(0).getCoverageName();
            ArrayList<Integer> bandIndices = new ArrayList<Integer>(selectedBands.size());
            for (CoverageView.InputCoverageBand icb : selectedBands) {
                int bandIdx = 0;
                String bandString = icb.getBand();
                if (bandString != null && !bandString.isEmpty()) {
                    bandIdx = Integer.parseInt(bandString);
                }
                bandIndices.add(bandIdx);
            }
            GridCoverage2D coverage = inputAlphaNonNull.inputCoverages.get(coverageName);
            Hints localHints = new Hints((RenderingHints)this.hints);
            if (inputAlphaNonNull.dynamicAlphaSource != null && mergedBands.size() == 1 && (bandIndices.size() == 1 || bandIndices.size() == 3)) {
                int alphaBandIndex = this.getAlphaBandIndex(coverage);
                this.addAlphaColorModelHint(localHints, bandIndices.size());
                bandIndices.add(alphaBandIndex);
            }
            coverage = this.retainBands(bandIndices, coverage, localHints);
            if (mergedBands.size() > 1) {
                coverage = this.prepareForBandMerge(coverage);
            }
            coverages.add(coverage);
            if (resolutionChooser.visit(coverage)) {
                transformationChoice = index;
            }
            ++index;
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "Read coverage " + coverageName + ", result has envelope " + String.valueOf(coverage.getEnvelope2D()));
        }
        if (coverages.size() > 1) {
            int currentBandCount;
            Hints localHints = new Hints((RenderingHints)this.hints);
            if (inputAlphaNonNull.dynamicAlphaSource != null && ((currentBandCount = this.countBands(coverages)) == 1 || currentBandCount == 3)) {
                int alphaBandIndex = this.getAlphaBandIndex(inputAlphaNonNull.dynamicAlphaSource);
                GridCoverage2D alphaBandCoverage = this.retainBands(Arrays.asList(alphaBandIndex), inputAlphaNonNull.dynamicAlphaSource, this.hints);
                coverages.add(alphaBandCoverage);
                this.addAlphaColorModelHint(localHints, currentBandCount);
            }
            String operationName = "BandMerge";
            ParameterValueGroup param = PROCESSOR.getOperation(operationName).getParameters();
            if (!this.handler.isHomogeneousCoverages()) {
                param.parameter("transform_choice").setValue((Object)"index");
                param.parameter("coverage_idx").setValue(transformationChoice);
            }
            param.parameter("sources").setValue(coverages);
            localHints.put((Object)ImageN.KEY_COLOR_MODEL_FACTORY, (sampleModel, sources, configuration) -> {
                int dataType = sampleModel.getDataType();
                int numBands = sampleModel.getNumBands();
                return RasterFactory.createComponentColorModel((int)dataType, (ColorSpace)(switch (numBands) {
                    case 1, 2 -> ColorSpace.getInstance(1003);
                    case 3 -> ColorSpace.getInstance(1000);
                    default -> new NotAColorSpace(numBands);
                }), (boolean)false, (boolean)false, (int)1);
            });
            result = (GridCoverage2D)PROCESSOR.doOperation(param, localHints);
        } else {
            result = (GridCoverage2D)coverages.get(0);
        }
        return result;
    }

    private GridCoverage2D readUsingJiffle(ViewInputs viewInputs) {
        HashMap<String, GridCoverage2D> inputCoverages = viewInputs.getInputCoverages();
        ArrayList<String> coverageOrder = new ArrayList<String>(inputCoverages.keySet());
        GridCoverage2D[] coverages = inputCoverages.values().toArray(new GridCoverage2D[0]);
        GridCoverage2D reference = coverages[0];
        String destName = this.coverageView.getOutputName();
        String script = this.coverageView.getDefinition();
        List<CoverageView.CoverageBand> outputBands = this.coverageView.getCoverageBands();
        List<CoverageView.InputCoverageBand> inputBands = outputBands.get(0).getInputCoverageBands();
        Set usedBandNames = inputBands.stream().map(CoverageView.InputCoverageBand::getCoverageName).collect(Collectors.toSet());
        List<String> sourceBands = coverageOrder.stream().filter(usedBandNames::contains).collect(Collectors.toList());
        RenderedImage[] sources = new RenderedImage[inputCoverages.size()];
        sources[0] = reference.getRenderedImage();
        for (int i = 1; i < sources.length; ++i) {
            GridCoverage2D coverage = coverages[i];
            if (coverage.getGridGeometry().equals((Object)reference.getGridGeometry())) {
                sources[i] = coverage.getRenderedImage();
                continue;
            }
            double[] nodata = CoverageUtilities.getBackgroundValues((GridCoverage2D)coverage);
            ROI roi = CoverageUtilities.getROIProperty((GridCoverage2D)coverage);
            sources[i] = GridCoverage2DRIA.create((GridCoverage2D)coverage, (GridCoverage2D)reference, (double[])nodata, (Hints)this.hints, (ROI)roi);
        }
        String[] sourceNames = sourceBands.toArray(new String[0]);
        int outputBandCount = outputBands.size();
        Range[] nodatas = new Range[sources.length];
        nodatas = this.getNodatas(nodatas, coverages);
        RenderedOp result = JiffleDescriptor.create((RenderedImage[])sources, (String[])sourceNames, (String)destName, (String)script, null, null, (Integer)outputBandCount, null, null, (Range[])nodatas, (RenderingHints)this.hints);
        GridSampleDimension[] sampleDimensions = this.getSampleDimensions(result, destName);
        GridCoverageFactory factory = new GridCoverageFactory(this.hints);
        return factory.create((CharSequence)"jiffle", (RenderedImage)result, reference.getEnvelope(), sampleDimensions, (GridCoverage[])coverages, null);
    }

    private GridSampleDimension[] getSampleDimensions(RenderedOp result, String destName) {
        SampleModel sm = result.getSampleModel();
        Stream<String> names = this.getBandNames(sm.getNumBands(), destName);
        SampleDimensionType sourceType = TypeMap.getSampleDimensionType((SampleModel)sm, (int)0);
        NumberRange range = TypeMap.getRange((SampleDimensionType)sourceType);
        double[] nodata = null;
        double min = range.getMinimum();
        double max = range.getMaximum();
        return (GridSampleDimension[])names.map(n -> new GridSampleDimension((CharSequence)n, sourceType, null, nodata, min, max, 1.0, 0.0, null)).toArray(GridSampleDimension[]::new);
    }

    private Stream<String> getBandNames(int numBands, String destName) {
        if (numBands == 1) {
            return Stream.of(destName);
        }
        return IntStream.range(1, numBands + 1).mapToObj(n -> destName + n);
    }

    private Range[] getNodatas(Range[] nodatas, GridCoverage2D[] coverages) {
        for (int i = 0; i < coverages.length; ++i) {
            GridCoverage2D coverage = coverages[i];
            NoDataContainer coverageNoData = CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage);
            if (coverageNoData == null) continue;
            nodatas[i] = coverageNoData.getAsRange();
        }
        if (Arrays.stream(nodatas).filter(n -> n != null).count() == 0L) {
            nodatas = null;
        }
        return nodatas;
    }

    private ViewInputs getInputAlphaNonNullCoverages(GeneralParameterValue[] parameters, ArrayList<Integer> selectedBandIndices, List<CoverageView.CoverageBand> bands, CoverageViewHandler.CoveragesConsistencyChecker checker, Boolean includeCoverages, CoverageView.CompositionType compositionType, boolean fillMissingBands) throws IOException {
        GeneralParameterValue[] filteredParameters;
        boolean multiThreadedLoading = false;
        if (parameters != null) {
            filteredParameters = (GeneralParameterValue[])Arrays.stream(parameters).filter(parameter -> !this.matches((GeneralParameterValue)parameter, (ParameterDescriptor<?>)AbstractGridFormat.BANDS)).toArray(GeneralParameterValue[]::new);
            multiThreadedLoading = Arrays.stream(parameters).filter(parameter -> this.matches((GeneralParameterValue)parameter, (ParameterDescriptor<?>)ImageMosaicFormat.ALLOW_MULTITHREADING)).map(p -> Boolean.TRUE.equals(((ParameterValue)p).getValue())).findFirst().orElse(false);
        } else {
            filteredParameters = null;
        }
        CoverageViewComposer composer = new CoverageViewComposer(fillMissingBands, this.handler, this.coverageFactory);
        Iterator<Object> iterator = selectedBandIndices.iterator();
        while (iterator.hasNext()) {
            int bIdx = iterator.next();
            CoverageView.CoverageBand coverageBand = bands.get(bIdx);
            List<CoverageView.InputCoverageBand> selectedBands = coverageBand.getInputCoverageBands();
            List<CoverageView.InputCoverageBand> inputBands = compositionType == CoverageView.CompositionType.BAND_SELECT ? Collections.singletonList(selectedBands.get(0)) : selectedBands;
            for (CoverageView.InputCoverageBand inputBand : inputBands) {
                String coverageName = inputBand.getCoverageName();
                if (composer.containsCoverage(coverageName)) continue;
                SingleGridCoverage2DReader reader = SingleGridCoverage2DReader.wrap(this.delegate, coverageName);
                composer.putReader(coverageName, reader);
                if (checker == null) {
                    checker = new CoverageViewHandler.CoveragesConsistencyChecker(reader);
                    continue;
                }
                checker.checkConsistency(reader);
            }
        }
        if (Boolean.TRUE.equals(includeCoverages)) {
            if (!multiThreadedLoading || EXECUTOR == null) {
                for (String coverageName : composer.getCoverageNames()) {
                    GridCoverage2D coverage;
                    GridCoverage2DReader gridCoverage2DReader;
                    if (composer.shouldProcessCoverage(coverageName, gridCoverage2DReader = composer.getReader(coverageName), coverage = gridCoverage2DReader.read(filteredParameters))) continue;
                    return null;
                }
                if (!composer.canCompose()) {
                    return null;
                }
            } else {
                ArrayList<Future<ParallelLoadingResult>> futures = new ArrayList<Future<ParallelLoadingResult>>();
                for (String string : composer.getCoverageNames()) {
                    Future<ParallelLoadingResult> future = EXECUTOR.submit(() -> {
                        GridCoverage2DReader reader = composer.getReader(coverageName);
                        GridCoverage2D coverage = reader.read(filteredParameters);
                        return new ParallelLoadingResult(coverageName, reader, coverage);
                    });
                    futures.add(future);
                }
                for (Future future : futures) {
                    try {
                        ParallelLoadingResult result = (ParallelLoadingResult)future.get();
                        if (composer.shouldProcessCoverage(result.coverageName, result.reader, result.coverage)) continue;
                        return null;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                if (!composer.canCompose()) {
                    return null;
                }
            }
        }
        return composer.prepareViewInputs(bands);
    }

    private static ArrayList<Integer> getBandIndices(GeneralParameterValue[] parameters, List<CoverageView.CoverageBand> bands) {
        int coverageBandsSize = bands.size();
        ArrayList<Integer> selectedBandIndices = new ArrayList<Integer>();
        for (int m = 0; m < coverageBandsSize; ++m) {
            selectedBandIndices.add(m);
        }
        if (parameters != null) {
            for (GeneralParameterValue parameter : parameters) {
                int[] bandIndicesParam;
                ParameterValue param = (ParameterValue)parameter;
                if (!AbstractGridFormat.BANDS.getName().equals(param.getDescriptor().getName()) || (bandIndicesParam = (int[])param.getValue()) == null) continue;
                selectedBandIndices = new ArrayList();
                for (int j : bandIndicesParam) {
                    selectedBandIndices.add(j);
                }
                break;
            }
        }
        return selectedBandIndices;
    }

    private static ArrayList<CoverageView.CoverageBand> getMergedBands(ArrayList<Integer> selectedBandIndices, List<CoverageView.CoverageBand> bands) {
        ArrayList<CoverageView.CoverageBand> mergedBands = new ArrayList<CoverageView.CoverageBand>();
        CoverageView.CoverageBand mBand = null;
        for (int idx = 0; idx < selectedBandIndices.size(); ++idx) {
            if (mBand == null) {
                mBand = new CoverageView.CoverageBand();
                mBand.setInputCoverageBands(bands.get(selectedBandIndices.get(idx)).getInputCoverageBands());
            }
            String coverageName = bands.get(selectedBandIndices.get(idx)).getInputCoverageBands().get(0).getCoverageName();
            if (idx + 1 < selectedBandIndices.size() && bands.get(selectedBandIndices.get(idx + 1)).getInputCoverageBands().get(0).getCoverageName().equals(coverageName)) {
                ArrayList<CoverageView.InputCoverageBand> groupBands = new ArrayList<CoverageView.InputCoverageBand>();
                groupBands.addAll(mBand.getInputCoverageBands());
                groupBands.addAll(bands.get(selectedBandIndices.get(idx + 1)).getInputCoverageBands());
                mBand.setInputCoverageBands(groupBands);
                continue;
            }
            mergedBands.add(mBand);
            mBand = null;
        }
        return mergedBands;
    }

    private boolean matches(GeneralParameterValue parameter, ParameterDescriptor<?> expected) {
        return parameter.getDescriptor().getName().equals(expected.getName());
    }

    private GridCoverage2D prepareForBandMerge(GridCoverage2D coverage) {
        RenderedImage ri = coverage.getRenderedImage();
        SampleModel sampleModel = ri.getSampleModel();
        if (sampleModel.getNumBands() == 1 && ri.getColorModel() instanceof IndexColorModel) {
            ImageWorker worker = new ImageWorker(ri);
            worker.removeIndexColorModel();
            RenderedImage formatted = worker.getRenderedImage();
            return new GridCoverageFactory().create((CharSequence)coverage.getName(), formatted, coverage.getGridGeometry(), coverage.getSampleDimensions(), new GridCoverage[]{coverage}, coverage.getProperties());
        }
        return coverage;
    }

    private void addAlphaColorModelHint(Hints localHints, int currentBandCount) {
        ImageLayout layout = new ImageLayout();
        ColorModel alphaModel = this.getColorModelWithAlpha(currentBandCount);
        layout.setColorModel(alphaModel);
        localHints.put((Object)ImageN.KEY_IMAGE_LAYOUT, (Object)layout);
    }

    private ColorModel getColorModelWithAlpha(int currentBandCount) {
        if (currentBandCount == 3) {
            ColorSpace cs = ColorSpace.getInstance(1000);
            int[] nBits = new int[]{8, 8, 8, 8};
            return new ComponentColorModel(cs, nBits, true, false, 3, 0);
        }
        if (currentBandCount == 1) {
            ColorSpace cs = ColorSpace.getInstance(1003);
            int[] nBits = new int[]{8, 8};
            return new ComponentColorModel(cs, nBits, true, false, 3, 0);
        }
        throw new IllegalArgumentException("Cannot create a color model with alpha support starting with " + currentBandCount + " bands");
    }

    private int countBands(List<GridCoverage2D> coverages) {
        int count = 0;
        for (GridCoverage2D coverage : coverages) {
            count += coverage.getRenderedImage().getSampleModel().getNumBands();
        }
        return count;
    }

    private int getAlphaBandIndex(GridCoverage2D coverage) {
        ColorModel cm = coverage.getRenderedImage().getColorModel();
        if (!cm.hasAlpha() || cm.getNumComponents() == cm.getNumColorComponents()) {
            throw new IllegalArgumentException("The source coverage does not have an alpha band, cannot extract an alpha band");
        }
        if (cm.getNumColorComponents() == 1) {
            return 1;
        }
        return 3;
    }

    private GridCoverage2D retainBands(List<Integer> bandIndices, GridCoverage2D coverage, Hints hints) {
        ParameterValueGroup param = PROCESSOR.getOperation("SelectSampleDimension").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        int[] sampleDimensionArray = ArrayUtils.toPrimitive((Integer[])bandIndices.toArray(new Integer[bandIndices.size()]));
        param.parameter("SampleDimensions").setValue((Object)sampleDimensionArray);
        coverage = (GridCoverage2D)PROCESSOR.doOperation(param, hints);
        return coverage;
    }

    protected void checkCoverageName(String coverageName) {
        if (!this.coverageName.equalsIgnoreCase(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName isn't the one of this coverageView");
        }
    }

    public void dispose() throws IOException {
        this.delegate.dispose();
    }

    public static GridCoverage2DReader wrap(GridCoverage2DReader reader, CoverageView coverageView, CoverageInfo coverageInfo, Hints hints) {
        if (reader instanceof StructuredGridCoverage2DReader) {
            StructuredGridCoverage2DReader dReader = (StructuredGridCoverage2DReader)reader;
            return new StructuredCoverageViewReader(dReader, coverageView, coverageInfo, hints);
        }
        return new CoverageViewReader(reader, coverageView, coverageInfo, hints);
    }

    public Format getFormat() {
        return new AbstractGridFormat(){
            private final AbstractGridFormat delegateFormat;
            {
                this.delegateFormat = (AbstractGridFormat)CoverageViewReader.this.delegate.getFormat();
            }

            public ParameterValueGroup getWriteParameters() {
                return this.delegateFormat.getWriteParameters();
            }

            public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
                return this.delegateFormat.getDefaultImageIOWriteParameters();
            }

            public GridCoverageWriter getWriter(Object o, Hints hints) {
                return this.delegateFormat.getWriter(o, hints);
            }

            public String getVersion() {
                return this.delegateFormat.getVersion();
            }

            public AbstractGridCoverage2DReader getReader(Object o) {
                return this.delegateFormat.getReader(o);
            }

            public AbstractGridCoverage2DReader getReader(Object o, Hints hints) {
                return this.delegateFormat.getReader(o, hints);
            }

            public GridCoverageWriter getWriter(Object o) {
                return this.delegateFormat.getWriter(o);
            }

            public boolean accepts(Object o, Hints hints) {
                return this.delegateFormat.accepts(o, hints);
            }

            public String getVendor() {
                return this.delegateFormat.getVendor();
            }

            public ParameterValueGroup getReadParameters() {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("name", this.getName());
                info.put("description", this.getDescription());
                info.put("vendor", this.getVendor());
                info.put("docURL", this.getDocURL());
                info.put("version", this.getVersion());
                ArrayList<DefaultParameterDescriptor> delegateFormatParams = new ArrayList<DefaultParameterDescriptor>();
                delegateFormatParams.addAll(this.delegateFormat.getReadParameters().getDescriptor().descriptors());
                if (!CoverageViewReader.this.checkIfDelegateReaderSupportsBands()) {
                    delegateFormatParams.add(AbstractGridFormat.BANDS);
                }
                return new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(info, delegateFormatParams.toArray(new GeneralParameterDescriptor[delegateFormatParams.size()])));
            }

            public String getName() {
                return this.delegateFormat.getName();
            }

            public String getDocURL() {
                return this.delegateFormat.getDocURL();
            }

            public String getDescription() {
                return this.delegateFormat.getDescription();
            }
        };
    }

    private boolean checkIfDelegateReaderSupportsBands() {
        List parameters = this.delegate.getFormat().getReadParameters().getDescriptor().descriptors();
        for (GeneralParameterDescriptor parameterDescriptor : parameters) {
            if (!parameterDescriptor.getName().equals(AbstractGridFormat.BANDS.getName())) continue;
            return true;
        }
        return false;
    }

    public Object getSource() {
        return this.delegate.getSource();
    }

    public String[] getMetadataNames(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getMetadataNames(this.referenceName);
    }

    public String getMetadataValue(String coverageName, String name) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getMetadataValue(this.referenceName, name);
    }

    public String[] getGridCoverageNames() throws IOException {
        return this.delegate.getGridCoverageNames();
    }

    public int getGridCoverageCount() throws IOException {
        return this.delegate.getGridCoverageCount();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getCoordinateReferenceSystem(this.referenceName);
    }

    public GeneralBounds getOriginalEnvelope(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.getOriginalEnvelope();
    }

    public GridEnvelope getOriginalGridRange(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.getOriginalGridRange();
    }

    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        this.checkCoverageName(coverageName);
        return this.getOriginalGridToWorld(pixInCell);
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue ... parameters) throws IOException {
        this.checkCoverageName(coverageName);
        return this.read(parameters);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getDynamicParameters(this.referenceName);
    }

    public double[] getReadingResolutions(String coverageName, OverviewPolicy policy, double[] requestedResolution) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getReadingResolutions(this.referenceName, policy, requestedResolution);
    }

    public ImageLayout getImageLayout() throws IOException {
        return this.imageLayout;
    }

    public ImageLayout getImageLayout(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.imageLayout;
    }

    public double[][] getResolutionLevels(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.getResolutionLevels();
    }

    public String[] getMetadataNames() throws IOException {
        return this.delegate.getMetadataNames(this.referenceName);
    }

    public String getMetadataValue(String name) throws IOException {
        return this.delegate.getMetadataValue(this.referenceName, name);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.delegate.getCoordinateReferenceSystem(this.referenceName);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters() throws IOException {
        return this.delegate.getDynamicParameters(this.referenceName);
    }

    public DatasetLayout getDatasetLayout() {
        return this.delegate.getDatasetLayout();
    }

    public DatasetLayout getDatasetLayout(String coverageName) {
        return this.delegate.getDatasetLayout(coverageName);
    }

    public ServiceInfo getInfo() {
        return this.delegate.getInfo();
    }

    public ResourceInfo getInfo(String coverageName) {
        List<CoverageView.CoverageBand> bands = this.coverageView.getCoverageBands();
        ArrayList<Integer> selectedBandIndices = CoverageViewReader.getBandIndices(null, bands);
        try {
            CoverageView.CompositionType compositionType = this.coverageView.getCompositionType() != null ? this.coverageView.getCompositionType() : CoverageView.CompositionType.BAND_SELECT;
            ViewInputs viewInputs = this.getInputAlphaNonNullCoverages(null, selectedBandIndices, bands, null, false, compositionType, false);
            if (this.viewHasPAM(viewInputs)) {
                return new CoverageViewPamResourceInfo(viewInputs);
            }
            return new DefaultResourceInfo();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while getting input coverages from Coverage View", e);
            return null;
        }
    }

    private boolean viewHasPAM(ViewInputs info) {
        HashMap<String, GridCoverage2DReader> readers = info.getInputReaders();
        for (CoverageView.CoverageBand band : info.getBands()) {
            for (CoverageView.InputCoverageBand inputCoverageBand : band.getInputCoverageBands()) {
                GridCoverage2DReader bandReader;
                ResourceInfo resourceInfoBand;
                GridCoverageReader reader1 = (GridCoverageReader)readers.get(inputCoverageBand.getCoverageName());
                if (!(reader1 instanceof GridCoverage2DReader) || !((resourceInfoBand = (bandReader = (GridCoverage2DReader)reader1).getInfo(inputCoverageBand.getCoverageName())) instanceof PAMResourceInfo)) continue;
                return true;
            }
        }
        return false;
    }

    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) throws IOException {
        return this.handler.getReadingResolutions(policy, requestedResolution);
    }

    public double[][] getResolutionLevels() throws IOException {
        return this.handler.getResolutionLevels();
    }

    public GeneralBounds getOriginalEnvelope() {
        return this.handler.getOriginalEnvelope();
    }

    public GridEnvelope getOriginalGridRange() {
        return this.handler.getOriginalGridRange();
    }

    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        return this.handler.getOriginalGridToWorld(pixInCell);
    }

    static class ViewInputs {
        private final List<CoverageView.CoverageBand> bands;
        private final HashMap<String, GridCoverage2DReader> inputReaders;
        private final HashMap<String, GridCoverage2D> inputCoverages;
        private final GridCoverage2D dynamicAlphaSource;
        private final int nonNullCoverages;

        public ViewInputs(List<CoverageView.CoverageBand> bands, HashMap<String, GridCoverage2DReader> inputReaders, HashMap<String, GridCoverage2D> inputCoverages, GridCoverage2D dynamicAlphaSource, int nonNullCoverages) {
            this.bands = bands;
            this.inputCoverages = inputCoverages;
            this.dynamicAlphaSource = dynamicAlphaSource;
            this.nonNullCoverages = nonNullCoverages;
            this.inputReaders = inputReaders;
        }

        public List<CoverageView.CoverageBand> getBands() {
            return this.bands;
        }

        public HashMap<String, GridCoverage2D> getInputCoverages() {
            return this.inputCoverages;
        }

        public GridCoverage2D getDynamicAlphaSource() {
            return this.dynamicAlphaSource;
        }

        public int getNonNullCoverages() {
            return this.nonNullCoverages;
        }

        public HashMap<String, GridCoverage2DReader> getInputReaders() {
            return this.inputReaders;
        }
    }

    static class ParallelLoadingResult {
        String coverageName;
        GridCoverage2DReader reader;
        GridCoverage2D coverage;

        public ParallelLoadingResult(String coverageName, GridCoverage2DReader reader, GridCoverage2D coverage) {
            this.coverageName = coverageName;
            this.reader = reader;
            this.coverage = coverage;
        }
    }
}

