/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.platform.ServiceException;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.style.FeatureTypeConstraint;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.NamedStyle;
import org.geotools.api.style.RemoteOWS;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.UserLayer;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.feature.SchemaException;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public abstract class GeoServerSLDVisitor
extends AbstractStyleVisitor {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog");
    protected final Catalog catalog;
    protected final CoordinateReferenceSystem fallbackCrs;
    protected PublishedInfo info;
    protected StyledLayer layer;
    protected int styleCount = 0;

    public GeoServerSLDVisitor(Catalog catalog, CoordinateReferenceSystem fallbackCrs) {
        this.catalog = catalog;
        this.fallbackCrs = fallbackCrs;
    }

    public abstract PublishedInfo visitNamedLayerInternal(StyledLayer var1);

    public abstract void visitUserLayerRemoteOWS(UserLayer var1);

    public abstract void visitUserLayerInlineFeature(UserLayer var1);

    public abstract StyleInfo visitNamedStyleInternal(NamedStyle var1);

    public abstract void visitUserStyleInternal(Style var1);

    public void visit(StyledLayerDescriptor sld) {
        if (sld.getStyledLayers().length == 0) {
            throw new IllegalStateException("SLD document contains no layers");
        }
        super.visit(sld);
    }

    public void visit(NamedLayer layer) {
        if (null == layer.getName()) {
            throw new ServiceException("A UserLayer or NamedLayer without layer name was passed");
        }
        this.setLayerState(this.visitNamedLayerInternal((StyledLayer)layer), (StyledLayer)layer);
        if (!this.handleLayerGroup()) {
            super.visit(layer);
        }
        this.handleNoStyles();
        this.clearLayerState();
    }

    public void visit(UserLayer layer) {
        if (null == layer.getName()) {
            throw new ServiceException("A UserLayer or NamedLayer without layer name was passed");
        }
        if (layer.getRemoteOWS() != null) {
            List<LayerInfo> layers = this.getRemoteLayersFromUserLayer(layer);
            this.visitUserLayerRemoteOWS(layer);
            for (LayerInfo layerInfo : layers) {
                this.setLayerState(layerInfo, (StyledLayer)layer);
                super.visit(layer);
                this.clearLayerState();
            }
            return;
        }
        if ((DataStore)layer.getInlineFeatureDatastore() != null) {
            try {
                this.setLayerState(this.getInlineFeatureLayer(layer, this.fallbackCrs), (StyledLayer)layer);
            }
            catch (SchemaException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException io) {
                throw new UncheckedIOException(io);
            }
            this.visitUserLayerInlineFeature(layer);
        } else {
            this.setLayerState(this.visitNamedLayerInternal((StyledLayer)layer), (StyledLayer)layer);
        }
        super.visit(layer);
        this.handleNoStyles();
        this.clearLayerState();
    }

    protected void setLayerState(PublishedInfo info, StyledLayer layer) {
        this.info = info;
        this.layer = layer;
    }

    protected void clearLayerState() {
        this.info = null;
        this.layer = null;
    }

    protected boolean handleLayerGroup() {
        PublishedInfo publishedInfo;
        if (this.info != null && (publishedInfo = this.info) instanceof LayerGroupInfo) {
            LayerGroupInfo lg = (LayerGroupInfo)publishedInfo;
            List<LayerInfo> layers = lg.layers();
            List<StyleInfo> styles = lg.styles();
            try {
                for (int i = 0; i < layers.size(); ++i) {
                    this.info = layers.get(i);
                    StyleInfo style = styles.get(i);
                    if (style == null) {
                        this.visit(layers.get(i).getDefaultStyle().getStyle());
                        continue;
                    }
                    this.visit(styles.get(i).getStyle());
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return true;
        }
        return false;
    }

    protected void handleNoStyles() {
        try {
            LayerInfo layerInfo;
            StyleInfo styleInfo;
            PublishedInfo publishedInfo;
            if (this.styleCount == 0 && this.info != null && (publishedInfo = this.info) instanceof LayerInfo && (styleInfo = (layerInfo = (LayerInfo)publishedInfo).getDefaultStyle()) != null) {
                this.visit(styleInfo.getStyle());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.styleCount = 0;
        }
    }

    public void visit(Style style) {
        ++this.styleCount;
        if (style instanceof NamedStyle) {
            NamedStyle namedStyle = (NamedStyle)style;
            this.visitNamedStyleInternal(namedStyle);
        } else {
            this.visitUserStyleInternal(style);
        }
        super.visit(style);
    }

    protected List<LayerInfo> getRemoteLayersFromUserLayer(UserLayer ul) throws ServiceException {
        try {
            RemoteOWS service = ul.getRemoteOWS();
            if (!service.getService().equalsIgnoreCase("WFS")) {
                throw new UnsupportedOperationException("GeoServer only supports WFS as remoteOWS service");
            }
            if (service.getOnlineResource() == null) {
                throw new IllegalStateException("OnlineResource for remote WFS not specified in SLD");
            }
            FeatureTypeConstraint[] featureConstraints = ul.getLayerFeatureConstraints();
            if (featureConstraints == null || featureConstraints.length == 0) {
                throw new IllegalStateException("No FeatureTypeConstraint specified, no layer can be loaded for this UserStyle");
            }
            DataStore remoteWFS = null;
            ArrayList<String> remoteTypeNames = null;
            try {
                URL url = new URL(service.getOnlineResource());
                remoteWFS = GeoServerSLDVisitor.connectRemoteWFS(url);
                remoteTypeNames = new ArrayList<String>(Arrays.asList(remoteWFS.getTypeNames()));
                Collections.sort(remoteTypeNames);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Invalid online resource url: '" + service.getOnlineResource() + "'");
            }
            ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
            Style[] layerStyles = ul.getUserStyles();
            for (FeatureTypeConstraint featureConstraint : featureConstraints) {
                String name = featureConstraint.getFeatureTypeName();
                if (Collections.binarySearch(remoteTypeNames, name) < 0) {
                    throw new IllegalStateException("Could not find layer feature type '" + name + "' on remote WFS '" + service.getOnlineResource());
                }
                layers.add(this.getLayerFromFeatureSource((FeatureSource<? extends FeatureType, ? extends Feature>)remoteWFS.getFeatureSource(name)));
            }
            return layers;
        }
        catch (IOException e) {
            throw new ServiceException("Error accessing remote layers", (Throwable)e, "RemoteAccessFailed");
        }
    }

    protected static DataStore connectRemoteWFS(URL remoteOwsUrl) {
        try {
            WFSDataStoreFactory storeFactory = new WFSDataStoreFactory();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(WFSDataStoreFactory.URL.key, String.valueOf(remoteOwsUrl) + "&request=GetCapabilities&service=WFS");
            params.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.TRUE);
            WFSDataStore dataStore = storeFactory.createDataStore(params);
            return dataStore;
        }
        catch (Exception e) {
            throw new ServiceException("Could not connect to remote OWS", (Throwable)e, "RemoteOWSFailure");
        }
    }

    protected LayerInfo getInlineFeatureLayer(UserLayer ul, CoordinateReferenceSystem fallbackCrs) throws SchemaException, IOException {
        SimpleFeatureSource featureSource;
        if (ul.getInlineFeatureType().getCoordinateReferenceSystem() == null) {
            LOGGER.warning("No CRS set on inline features default geometry.  Assuming the requestor has their inlinefeatures in the boundingbox CRS.");
            SimpleFeatureType currFt = ul.getInlineFeatureType();
            Query q = new Query(currFt.getTypeName(), (Filter)Filter.INCLUDE);
            DataStore inlineFeatureDatastore = (DataStore)ul.getInlineFeatureDatastore();
            DefaultGeographicCRS crs = fallbackCrs == null ? DefaultGeographicCRS.WGS84 : fallbackCrs;
            String typeName = inlineFeatureDatastore.getTypeNames()[0];
            MemoryDataStore reTypedDS = new MemoryDataStore((FeatureReader)new ForceCoordinateSystemFeatureReader(inlineFeatureDatastore.getFeatureReader(q, Transaction.AUTO_COMMIT), (CoordinateReferenceSystem)crs));
            featureSource = reTypedDS.getFeatureSource(typeName);
        } else {
            DataStore inlineFeatureDatastore = (DataStore)ul.getInlineFeatureDatastore();
            String typeName = inlineFeatureDatastore.getTypeNames()[0];
            featureSource = inlineFeatureDatastore.getFeatureSource(typeName);
        }
        return this.getLayerFromFeatureSource((FeatureSource<? extends FeatureType, ? extends Feature>)featureSource);
    }

    protected LayerInfo getLayerFromFeatureSource(FeatureSource<? extends FeatureType, ? extends Feature> featureSource) {
        FeatureSourceWrappingFeatureTypeInfoImpl featureTypeInfo = null;
        try {
            featureTypeInfo = new FeatureSourceWrappingFeatureTypeInfoImpl(featureSource);
        }
        catch (IOException | FactoryException | TransformException e) {
            throw new IllegalStateException("Error constructing wrapping feature source", e);
        }
        featureTypeInfo.setName(featureSource.getName().getLocalPart());
        featureTypeInfo.setEnabled(true);
        featureTypeInfo.setCatalog(this.catalog);
        LayerInfo layerInfo = this.catalog.getFactory().createLayer();
        layerInfo.setResource(featureTypeInfo);
        layerInfo.setEnabled(true);
        if (!(featureSource instanceof CollectionFeatureSource) && featureSource.getDataStore() instanceof WFSDataStore) {
            layerInfo.setType(PublishedType.REMOTE);
        } else {
            layerInfo.setType(PublishedType.VECTOR);
        }
        return layerInfo;
    }

    protected static class FeatureSourceWrappingFeatureTypeInfoImpl
    extends FeatureTypeInfoImpl {
        FeatureSource<? extends FeatureType, ? extends Feature> featureSource;

        public FeatureSourceWrappingFeatureTypeInfoImpl(FeatureSource<? extends FeatureType, ? extends Feature> featureSource) throws IOException, TransformException, FactoryException {
            this.featureSource = featureSource;
            this.setName(featureSource.getName().getLocalPart());
            this.setEnabled(true);
            this.setLatLonBoundingBox(featureSource.getBounds().transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true));
        }

        @Override
        public FeatureSource<? extends FeatureType, ? extends Feature> getFeatureSource(ProgressListener listener, Hints hints) {
            return this.featureSource;
        }

        @Override
        public FeatureType getFeatureType() throws IOException {
            return this.featureSource.getSchema();
        }

        @Override
        public Name getQualifiedName() {
            return this.featureSource.getName();
        }

        @Override
        public String prefixedName() {
            return this.featureSource.getName().getNamespaceURI() + ":" + this.getName();
        }

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public DataStoreInfo getStore() {
            return new DataStoreInfoImpl(){

                @Override
                public DataAccess<? extends FeatureType, ? extends Feature> getDataStore(ProgressListener listener) throws IOException {
                    return DataUtilities.dataStore((SimpleFeatureSource)((SimpleFeatureSource)featureSource));
                }
            };
        }
    }

    protected static class StyleWrappingStyleInfoImpl
    extends StyleInfoImpl {
        Style style;

        public StyleWrappingStyleInfoImpl(Style style) {
            this.style = style;
            this.setName(style.getName());
        }

        @Override
        public Style getStyle() {
            return this.style;
        }
    }
}

