/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.GeoServerSLDVisitor;
import org.geoserver.catalog.GeoServerSLDVisitorAdapter;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.WMSLayerInfoImpl;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.style.NamedStyle;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public class LayerGroupHelper {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog");
    private LayerGroupInfo group;
    final Catalog catalog;

    public LayerGroupHelper(LayerGroupInfo group) {
        this(LayerGroupHelper.catalog(), group);
    }

    public LayerGroupHelper(Catalog catalog, LayerGroupInfo group) {
        this.catalog = catalog;
        this.group = group;
    }

    private static Catalog catalog() {
        return (Catalog)GeoServerExtensions.bean((String)"catalog");
    }

    public List<LayerInfo> allLayers() {
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        this.allLayers(this.group, layers);
        return layers;
    }

    private void allLayers(LayerGroupInfo group, List<LayerInfo> layers) {
        if (LayerGroupInfo.Mode.EO.equals((Object)group.getMode())) {
            layers.add(group.getRootLayer());
        }
        int size = group.getLayers().size();
        for (int i = 0; i < size; ++i) {
            PublishedInfo p = group.getLayers().get(i);
            StyleInfo s = group.getStyles() == null || group.getStyles().isEmpty() ? null : group.getStyles().get(i);
            if (p instanceof LayerInfo) {
                LayerInfo l = (LayerInfo)p;
                layers.add(l);
                continue;
            }
            if (p instanceof LayerGroupInfo) {
                LayerGroupInfo groupInfo = (LayerGroupInfo)p;
                LayerGroupStyle lgStyle = LayerGroupHelper.getStyleOrThrow(groupInfo, s);
                if (lgStyle != null) {
                    this.allLayers(LayerGroupHelper.getCrs(groupInfo.getBounds()), lgStyle, layers);
                    continue;
                }
                this.allLayers(groupInfo, layers);
                continue;
            }
            if (p != null || s == null) continue;
            this.expandStyleGroup(s, group.getBounds() == null ? null : group.getBounds().getCoordinateReferenceSystem(), layers, null);
        }
    }

    public List<LayerInfo> allLayers(String styleName) {
        LayerGroupStyle lgStyle = LayerGroupHelper.getStyleOrThrow(this.group, styleName);
        ArrayList<LayerInfo> layerInfos = new ArrayList<LayerInfo>();
        CoordinateReferenceSystem crs = LayerGroupHelper.getCrs(this.group.getBounds());
        this.allLayers(crs, lgStyle, layerInfos);
        return layerInfos;
    }

    private void allLayers(CoordinateReferenceSystem crs, LayerGroupStyle groupStyle, List<LayerInfo> layers) {
        List<PublishedInfo> published = groupStyle.getLayers();
        List<StyleInfo> styles = groupStyle.getStyles();
        int pSize = published.size();
        int sSize = styles.size();
        for (int i = 0; i < pSize; ++i) {
            PublishedInfo p = published.get(i);
            StyleInfo s = styles == null || sSize == 0 ? null : styles.get(i);
            if (p instanceof LayerInfo) {
                LayerInfo l = (LayerInfo)p;
                layers.add(l);
                continue;
            }
            if (p instanceof LayerGroupInfo) {
                LayerGroupInfo groupInfo = (LayerGroupInfo)p;
                LayerGroupStyle lgStyle = LayerGroupHelper.getStyleOrThrow(groupInfo, s);
                if (lgStyle != null) {
                    this.allLayers(LayerGroupHelper.getCrs(groupInfo.getBounds()), lgStyle, layers);
                    continue;
                }
                this.allLayers(groupInfo, layers);
                continue;
            }
            if (p != null || s == null) continue;
            this.expandStyleGroup(s, crs, layers, null);
        }
    }

    private static CoordinateReferenceSystem getCrs(ReferencedEnvelope envelope) {
        CoordinateReferenceSystem crs = null;
        if (envelope != null) {
            crs = envelope.getCoordinateReferenceSystem();
        }
        return crs;
    }

    public List<PublishedInfo> allPublished() {
        ArrayList<PublishedInfo> publisheds = new ArrayList<PublishedInfo>();
        this.allPublished(this.group, publisheds);
        return publisheds;
    }

    private List<PublishedInfo> allPublished(LayerGroupInfo group, List<PublishedInfo> publisheds) {
        if (LayerGroupInfo.Mode.EO.equals((Object)group.getMode())) {
            publisheds.add(group.getRootLayer());
        }
        int size = group.getLayers().size();
        for (int i = 0; i < size; ++i) {
            PublishedInfo p = group.getLayers().get(i);
            StyleInfo s = group.getStyles() == null || group.getStyles().isEmpty() ? null : group.getStyles().get(i);
            if (p instanceof LayerInfo) {
                LayerInfo l = (LayerInfo)p;
                publisheds.add(l);
                continue;
            }
            if (p instanceof LayerGroupInfo) {
                publisheds.add(p);
                continue;
            }
            if (p != null || s == null) continue;
            ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
            this.expandStyleGroup(s, LayerGroupHelper.getCrs(group.getBounds()), layers, null);
            publisheds.addAll(layers);
        }
        return publisheds;
    }

    public List<LayerGroupInfo> allGroups() {
        ArrayList<LayerGroupInfo> groups = new ArrayList<LayerGroupInfo>();
        LayerGroupHelper.allGroups(this.group, groups);
        return groups;
    }

    private static void allGroups(LayerGroupInfo group, List<LayerGroupInfo> groups) {
        groups.add(group);
        for (PublishedInfo p : group.getLayers()) {
            if (!(p instanceof LayerGroupInfo)) continue;
            LayerGroupInfo g = (LayerGroupInfo)p;
            LayerGroupHelper.allGroups(g, groups);
        }
    }

    public List<StyleInfo> allStyles() {
        ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
        this.allStyles(this.group, styles);
        return styles;
    }

    private void allStyles(LayerGroupInfo group, List<StyleInfo> styles) {
        if (LayerGroupInfo.Mode.EO.equals((Object)group.getMode())) {
            styles.add(group.getRootLayerStyle());
        }
        int size = group.getLayers().size();
        for (int i = 0; i < size; ++i) {
            PublishedInfo p = group.getLayers().get(i);
            StyleInfo s = group.getStyles().get(i);
            if (p instanceof LayerInfo) {
                styles.add(group.getStyles().get(i));
                continue;
            }
            if (p instanceof LayerGroupInfo) {
                LayerGroupInfo groupInfo = (LayerGroupInfo)p;
                this.allStyles(groupInfo, styles);
                continue;
            }
            if (p != null || s == null) continue;
            this.expandStyleGroup(s, LayerGroupHelper.getCrs(group.getBounds()), null, styles);
        }
    }

    public List<LayerInfo> allLayersForRendering() {
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        this.allLayersForRendering(this.group, null, layers, true);
        return layers;
    }

    public List<LayerInfo> allLayersForRendering(String lgStyle) {
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        LayerGroupStyle groupStyle = LayerGroupHelper.getStyleOrThrow(this.group, lgStyle);
        CoordinateReferenceSystem crs = LayerGroupHelper.getCrs(this.group.getBounds());
        this.allLayers(crs, groupStyle, layers);
        return layers;
    }

    private void allLayersForRendering(LayerGroupInfo group, LayerGroupStyle groupStyle, List<LayerInfo> layers, boolean root) {
        switch (group.getMode()) {
            case EO: {
                layers.add(group.getRootLayer());
                break;
            }
            case CONTAINER: {
                if (root) {
                    throw new UnsupportedOperationException("LayerGroup mode " + LayerGroupInfo.Mode.CONTAINER.getName() + " can not be rendered");
                }
            }
            default: {
                List<PublishedInfo> publishables = groupStyle == null ? group.getLayers() : groupStyle.getLayers();
                List<StyleInfo> styles = groupStyle == null ? group.getStyles() : groupStyle.getStyles();
                int size = publishables.size();
                for (int i = 0; i < size; ++i) {
                    PublishedInfo p = publishables.get(i);
                    StyleInfo s = styles.get(i);
                    if (p instanceof LayerInfo) {
                        LayerInfo l = (LayerInfo)p;
                        layers.add(l);
                        continue;
                    }
                    if (p instanceof LayerGroupInfo) {
                        LayerGroupInfo groupInfo = (LayerGroupInfo)p;
                        LayerGroupStyle gStyle = null;
                        gStyle = LayerGroupHelper.getStyleOrThrow(groupInfo, s);
                        this.allLayersForRendering(groupInfo, gStyle, layers, false);
                        continue;
                    }
                    if (p != null || s == null) continue;
                    this.expandStyleGroup(s, LayerGroupHelper.getCrs(group.getBounds()), layers, null);
                }
            }
        }
    }

    private static LayerGroupStyle getStyleOrThrow(LayerGroupInfo groupInfo, StyleInfo styleName) {
        LayerGroupStyle groupStyle = null;
        if (styleName != null && styleName.getName() != null && !"".equals(styleName.getName())) {
            groupStyle = LayerGroupHelper.getStyleOrThrow(groupInfo, styleName.getName());
        }
        return groupStyle;
    }

    private static LayerGroupStyle getStyleOrThrow(LayerGroupInfo groupInfo, String styleName) {
        LayerGroupStyle groupStyle = LayerGroupHelper.getGroupStyleByName(groupInfo, styleName);
        if (groupStyle == null) {
            throw new NoSuchElementException("No Style with name " + styleName + " found for LayerGroup " + groupInfo.getName());
        }
        return groupStyle;
    }

    public List<StyleInfo> allStylesForRendering() {
        ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
        this.allStylesForRendering(this.group, null, styles, true);
        return styles;
    }

    private void allStylesForRendering(LayerGroupInfo group, LayerGroupStyle groupStyle, List<StyleInfo> styles, boolean root) {
        switch (group.getMode()) {
            case EO: {
                styles.add(group.getRootLayerStyle());
                break;
            }
            case CONTAINER: {
                if (root) {
                    throw new UnsupportedOperationException("LayerGroup mode " + LayerGroupInfo.Mode.CONTAINER.getName() + " can not be rendered");
                }
            }
            default: {
                List<PublishedInfo> publishables = groupStyle == null ? group.getLayers() : groupStyle.getLayers();
                List<StyleInfo> stylesList = groupStyle == null ? group.getStyles() : groupStyle.getStyles();
                int size = publishables.size();
                for (int i = 0; i < size; ++i) {
                    PublishedInfo p = publishables.get(i);
                    StyleInfo s = stylesList.get(i);
                    if (p instanceof LayerInfo) {
                        LayerInfo layerInfo = (LayerInfo)p;
                        if (layerInfo.getResource() instanceof WMSLayerInfo) {
                            WMSLayerInfo wmsLayerInfo = (WMSLayerInfo)layerInfo.getResource();
                            s = LayerGroupHelper.getRemoteWmsLayerStyle(wmsLayerInfo, s);
                        }
                        styles.add(s);
                        continue;
                    }
                    if (p instanceof LayerGroupInfo) {
                        LayerGroupInfo groupInfo = (LayerGroupInfo)p;
                        LayerGroupStyle groupStyle2 = LayerGroupHelper.getStyleOrThrow(groupInfo, s);
                        this.allStylesForRendering(groupInfo, groupStyle2, styles, false);
                        continue;
                    }
                    if (p != null || s == null) continue;
                    this.expandStyleGroup(s, LayerGroupHelper.getCrs(group.getBounds()), null, styles);
                }
            }
        }
    }

    public List<StyleInfo> allStylesForRendering(String styleName) {
        ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
        CoordinateReferenceSystem crs = LayerGroupHelper.getCrs(this.group.getBounds());
        LayerGroupStyle groupStyle = LayerGroupHelper.getStyleOrThrow(this.group, styleName);
        this.allStylesForRendering(crs, groupStyle, styles);
        return styles;
    }

    public void allStylesForRendering(CoordinateReferenceSystem crs, LayerGroupStyle groupStyle, List<StyleInfo> styleInfos) {
        List<PublishedInfo> publishable = groupStyle.getLayers();
        List<StyleInfo> styles = groupStyle.getStyles();
        int size = publishable.size();
        for (int i = 0; i < size; ++i) {
            PublishedInfo p = publishable.get(i);
            StyleInfo s = styles.get(i);
            if (p instanceof LayerInfo) {
                LayerInfo layerInfo = (LayerInfo)p;
                if (layerInfo.getResource() instanceof WMSLayerInfo) {
                    WMSLayerInfo wmsLayerInfo = (WMSLayerInfo)layerInfo.getResource();
                    s = LayerGroupHelper.getRemoteWmsLayerStyle(wmsLayerInfo, s);
                }
                styleInfos.add(s);
                continue;
            }
            if (p instanceof LayerGroupInfo) {
                LayerGroupInfo group = (LayerGroupInfo)p;
                LayerGroupStyle groupStyle2 = LayerGroupHelper.getStyleOrThrow(group, s);
                this.allStylesForRendering(group, groupStyle2, styleInfos, false);
                continue;
            }
            if (p != null || s == null) continue;
            this.expandStyleGroup(s, crs, null, styleInfos);
        }
    }

    public void calculateBounds(CoordinateReferenceSystem crs) throws Exception {
        List<LayerInfo> layers = this.allLayers();
        if (layers.isEmpty()) {
            return;
        }
        LayerInfo l = layers.get(0);
        ReferencedEnvelope bounds = new ReferencedEnvelope(crs);
        Iterator<LayerInfo> iterator = layers.iterator();
        while (iterator.hasNext()) {
            LayerInfo layer;
            l = layer = iterator.next();
            bounds.expandToInclude((Envelope)LayerGroupHelper.transform(l.getResource().getLatLonBoundingBox(), crs));
        }
        this.group.setBounds(bounds);
    }

    public void calculateBoundsFromCRS(CoordinateReferenceSystem crs) {
        Bounds crsEnvelope = CRS.getEnvelope((CoordinateReferenceSystem)crs);
        if (crsEnvelope != null) {
            ReferencedEnvelope refEnvelope = new ReferencedEnvelope(crsEnvelope);
            this.group.setBounds(refEnvelope);
        } else {
            this.group.setBounds(null);
        }
    }

    public void calculateBounds() throws Exception {
        List<LayerInfo> layers = this.allLayers();
        if (layers.isEmpty()) {
            return;
        }
        LayerInfo l = layers.get(0);
        ReferencedEnvelope bounds = l.getResource().boundingBox();
        boolean latlon = false;
        if (bounds == null) {
            bounds = l.getResource().getLatLonBoundingBox();
            latlon = true;
        }
        if (bounds == null) {
            throw new IllegalArgumentException("Could not calculate bounds from layer with no bounds, " + l.getName());
        }
        for (int i = 1; i < layers.size(); ++i) {
            ReferencedEnvelope re;
            l = layers.get(i);
            ResourceInfo resource = l.getResource();
            if (latlon) {
                re = resource.getLatLonBoundingBox();
            } else {
                re = resource.boundingBox();
                if (re == null) {
                    re = resource.getLatLonBoundingBox();
                }
            }
            re = LayerGroupHelper.transform(re, bounds.getCoordinateReferenceSystem());
            if (re == null) {
                throw new IllegalArgumentException("Could not calculate bounds from layer with no bounds, " + l.getName());
            }
            bounds.expandToInclude((Envelope)re);
        }
        this.group.setBounds(bounds);
    }

    private static ReferencedEnvelope transform(ReferencedEnvelope e, CoordinateReferenceSystem crs) throws TransformException, FactoryException {
        if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)e.getCoordinateReferenceSystem())) {
            return e.transform(crs, true);
        }
        return e;
    }

    public Stack<LayerGroupInfo> checkLoops() {
        Stack<LayerGroupInfo> path = new Stack<LayerGroupInfo>();
        if (this.checkLoops(this.group, this.group.getLayers(), this.group.getStyles(), path)) {
            return path;
        }
        if (this.checkLoops(this.group, this.group.getLayerGroupStyles(), path)) {
            return path;
        }
        return null;
    }

    public String getLoopAsString(Stack<LayerGroupInfo> path) {
        if (path == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (LayerGroupInfo g : path) {
            s.append("/").append(g.getName());
        }
        return s.toString();
    }

    private boolean checkLoops(LayerGroupInfo group, List<LayerGroupStyle> groupStyles, Stack<LayerGroupInfo> path) {
        if (groupStyles != null) {
            for (LayerGroupStyle groupStyle : groupStyles) {
                if (!this.checkLoops(group, groupStyle.getLayers(), groupStyle.getStyles(), path)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkLoops(LayerGroupInfo group, List<PublishedInfo> layers, List<StyleInfo> styles, Stack<LayerGroupInfo> path) {
        path.push(group);
        if (layers != null) {
            int size = layers.size();
            for (int i = 0; i < size; ++i) {
                PublishedInfo child = layers.get(i);
                StyleInfo s = styles == null || styles.isEmpty() ? null : styles.get(i);
                if (child instanceof LayerGroupInfo) {
                    LayerGroupInfo groupInfo = (LayerGroupInfo)child;
                    if (LayerGroupHelper.isGroupInStack(groupInfo, path)) {
                        path.push(groupInfo);
                        return true;
                    }
                    if (this.checkLoops(groupInfo, groupInfo.getLayers(), groupInfo.getStyles(), path)) {
                        return true;
                    }
                    if (!this.checkLoops(groupInfo, groupInfo.getLayerGroupStyles(), path)) continue;
                    return true;
                }
                if (child != null || s == null || !this.checkStyleGroupLoops(s, group, path)) continue;
                return true;
            }
        }
        path.pop();
        return false;
    }

    private boolean checkStyleGroupLoops(StyleInfo styleGroup, final LayerGroupInfo group, final Stack<LayerGroupInfo> path) {
        try {
            StyledLayerDescriptor sld = styleGroup.getSLD();
            final boolean[] hasLoop = new boolean[]{false};
            sld.accept((StyleVisitor)new GeoServerSLDVisitorAdapter(this.catalog, group.getBounds() == null ? null : group.getBounds().getCoordinateReferenceSystem()){
                private final IllegalStateException recursionException;
                {
                    super(catalog, fallbackCrs);
                    this.recursionException = new IllegalStateException("Style group contains recursive structure");
                }

                @Override
                public void visit(StyledLayerDescriptor sld) {
                    try {
                        super.visit(sld);
                    }
                    catch (IllegalStateException e) {
                        if (this.recursionException.equals(e)) {
                            hasLoop[0] = true;
                        }
                        throw e;
                    }
                }

                @Override
                public PublishedInfo visitNamedLayerInternal(StyledLayer namedLayer) {
                    if (namedLayer.getName() != null && namedLayer.getName().equals(group.getName())) {
                        throw this.recursionException;
                    }
                    LayerGroupInfo child = this.catalog.getLayerGroupByName(namedLayer.getName());
                    if (child != null) {
                        if (LayerGroupHelper.isGroupInStack(child, path)) {
                            path.push(child);
                            throw this.recursionException;
                        }
                        if (LayerGroupHelper.this.checkLoops(child, child.getLayers(), child.getStyles(), path)) {
                            throw this.recursionException;
                        }
                        return child;
                    }
                    return null;
                }
            });
            return hasLoop[0];
        }
        catch (IOException | UncheckedIOException | IllegalStateException | UnsupportedOperationException | ServiceException e) {
            LOGGER.log(Level.WARNING, "Error extracting layers from Style Group '" + styleGroup.getName() + "'. Skipping...", e);
            return false;
        }
    }

    private static boolean isGroupInStack(LayerGroupInfo group, Stack<LayerGroupInfo> path) {
        for (LayerGroupInfo groupInPath : path) {
            if (groupInPath.getId() == null || !groupInPath.getId().equals(group.getId())) continue;
            return true;
        }
        return false;
    }

    private void expandStyleGroup(StyleInfo styleGroup, CoordinateReferenceSystem crs, List<LayerInfo> layers, List<StyleInfo> styles) {
        if (layers == null) {
            layers = new ArrayList<LayerInfo>();
        }
        if (styles == null) {
            styles = new ArrayList<StyleInfo>();
        }
        try {
            StyledLayerDescriptor sld = styleGroup.getSLD();
            StyleGroupHelper helper = new StyleGroupHelper(this.catalog, crs);
            sld.accept((StyleVisitor)helper);
            layers.addAll(helper.getLayers());
            styles.addAll(helper.getStyles());
        }
        catch (IOException | UncheckedIOException | IllegalStateException | UnsupportedOperationException | ServiceException e) {
            LOGGER.log(Level.WARNING, "Error extracting styles from Style Group '" + styleGroup.getName() + "'. Skipping...", e);
        }
    }

    private static StyleInfo getRemoteWmsLayerStyle(WMSLayerInfo wmsLayerInfo, StyleInfo styleInfo) {
        if (styleInfo == null) {
            styleInfo = wmsLayerInfo.getDefaultStyle();
        } else if (wmsLayerInfo.findRemoteStyleByName(styleInfo.getName()).isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(styleInfo.getName() + " style is not a known remote style for WMS Layer " + String.valueOf(wmsLayerInfo) + ", Re-configure the Resource");
            }
            styleInfo = WMSLayerInfoImpl.DEFAULT_ON_REMOTE;
        }
        return styleInfo;
    }

    public static LayerGroupStyle getGroupStyleByName(LayerGroupInfo group, String styleName) {
        List<LayerGroupStyle> styles = group.getLayerGroupStyles();
        LayerGroupStyle result = null;
        if (styleName != null && !"".equals(styleName)) {
            for (LayerGroupStyle s : styles) {
                if (!s.getName().getName().equals(styleName)) continue;
                result = s;
                break;
            }
        }
        return result;
    }

    public static boolean isSingleOrOpaque(LayerGroupInfo groupInfo) {
        LayerGroupInfo.Mode mode = groupInfo.getMode();
        return mode.equals((Object)LayerGroupInfo.Mode.SINGLE) || mode.equals((Object)LayerGroupInfo.Mode.OPAQUE_CONTAINER);
    }

    protected static class StyleGroupHelper
    extends GeoServerSLDVisitorAdapter {
        List<LayerInfo> layers;
        List<StyleInfo> styles;

        public StyleGroupHelper(Catalog catalog, CoordinateReferenceSystem fallbackCrs) {
            super(catalog, fallbackCrs);
        }

        @Override
        public void visit(StyledLayerDescriptor sld) {
            this.layers = new ArrayList<LayerInfo>();
            this.styles = new ArrayList<StyleInfo>();
            super.visit(sld);
        }

        public List<LayerInfo> getLayers() {
            return this.layers;
        }

        public List<StyleInfo> getStyles() {
            return this.styles;
        }

        @Override
        public PublishedInfo visitNamedLayerInternal(StyledLayer namedLayer) {
            PublishedInfo p = this.catalog.getLayerGroupByName(namedLayer.getName());
            if (p == null && (p = this.catalog.getLayerByName(namedLayer.getName())) == null) {
                throw new ServiceException("No layer or layer group with name \"" + namedLayer.getName() + "\"");
            }
            return p;
        }

        @Override
        public StyleInfo visitNamedStyleInternal(NamedStyle namedStyle) {
            StyleInfo s = this.catalog.getStyleByName(namedStyle.getName());
            this.layers.add((LayerInfo)this.info);
            this.styles.add(s);
            return s;
        }

        @Override
        public void visitUserStyleInternal(Style userStyle) {
            this.layers.add((LayerInfo)this.info);
            GeoServerSLDVisitor.StyleWrappingStyleInfoImpl style = new GeoServerSLDVisitor.StyleWrappingStyleInfoImpl(userStyle);
            style.setCatalog(this.catalog);
            this.styles.add(style);
        }
    }
}

