/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.factory.CommonFactoryFinder;

@ParametersAreNonnullByDefault
public class Predicates {
    public static final FilterFactory factory = CommonFactoryFinder.getFilterFactory();
    public static final PropertyName ANY_TEXT = factory.property("AnyText");

    private Predicates() {
    }

    public static Filter acceptAll() {
        return Filter.INCLUDE;
    }

    public static Filter acceptNone() {
        return Filter.EXCLUDE;
    }

    public static Filter equal(String property, Object expected) {
        return Predicates.equal(property, expected, MultiValuedFilter.MatchAction.ANY);
    }

    public static Filter equal(String property, Object expected, MultiValuedFilter.MatchAction matchAction) {
        boolean matchCase = true;
        return factory.equal((Expression)factory.property(property), (Expression)factory.literal(expected), true, matchAction);
    }

    public static Filter contains(String property, String subsequence) {
        PropertyName propertyName = factory.property(property);
        return Predicates.contains(propertyName, subsequence);
    }

    public static Filter contains(PropertyName propertyName, String subsequence) {
        String pattern = "*" + Predicates.fixSpecials(subsequence) + "*";
        String wildcard = "*";
        String singleChar = "?";
        String escape = "\\";
        boolean matchCase = false;
        return factory.like((Expression)propertyName, pattern, wildcard, singleChar, escape, matchCase);
    }

    private static String fixSpecials(String inString) {
        StringBuffer tmp = new StringBuffer("");
        for (int i = 0; i < inString.length(); ++i) {
            char chr = inString.charAt(i);
            if (Predicates.isSpecial(chr)) {
                tmp.append("\\" + chr);
                continue;
            }
            tmp.append(chr);
        }
        return tmp.toString();
    }

    private static boolean isSpecial(char chr) {
        return chr == '.' || chr == '?' || chr == '*' || chr == '^' || chr == '$' || chr == '+' || chr == '[' || chr == ']' || chr == '(' || chr == ')' || chr == '|' || chr == '\\' || chr == '&' || chr == '}' || chr == '{';
    }

    public static Filter fullTextSearch(String subsequence) {
        return Predicates.contains(ANY_TEXT, subsequence);
    }

    public static Filter exactTermSearch(String term) {
        return factory.like((Expression)ANY_TEXT, Predicates.fixSpecials(term));
    }

    public static Filter and(Filter op1, Filter op2) {
        And and;
        ArrayList<Filter> children = new ArrayList<Filter>();
        if (op1 instanceof And) {
            and = (And)op1;
            children.addAll(and.getChildren());
        } else {
            children.add(op1);
        }
        if (op2 instanceof And) {
            and = (And)op2;
            children.addAll(and.getChildren());
        } else {
            children.add(op2);
        }
        return factory.and(children);
    }

    public static Filter not(Filter filter) {
        if (filter instanceof Not) {
            Not not = (Not)filter;
            return not.getFilter();
        }
        return factory.not(filter);
    }

    public static Filter and(Filter ... operands) {
        if (operands == null || operands.length == 0) {
            return Filter.INCLUDE;
        }
        if (operands.length == 1) {
            return operands[0];
        }
        ArrayList anded = Lists.newArrayList((Object[])operands);
        return Predicates.and(anded);
    }

    public static Filter and(List<Filter> operands) {
        if (operands.isEmpty()) {
            return Filter.INCLUDE;
        }
        if (operands.size() == 1) {
            return operands.get(0);
        }
        return factory.and(operands);
    }

    public static Filter or(Filter op1, Filter op2) {
        Or or;
        ArrayList<Filter> children = new ArrayList<Filter>();
        if (op1 instanceof Or) {
            or = (Or)op1;
            children.addAll(or.getChildren());
        } else {
            children.add(op1);
        }
        if (op2 instanceof Or) {
            or = (Or)op2;
            children.addAll(or.getChildren());
        } else {
            children.add(op2);
        }
        return factory.or(children);
    }

    public static Filter or(Filter ... operands) {
        ArrayList ored = Lists.newArrayList((Object[])operands);
        return factory.or((List)ored);
    }

    public static Filter or(List<Filter> operands) {
        if (operands.isEmpty()) {
            return Filter.EXCLUDE;
        }
        if (operands.size() == 1) {
            return operands.get(0);
        }
        return factory.or(operands);
    }

    public static Filter isNull(String propertyName) {
        return factory.isNull((Expression)factory.property(propertyName));
    }

    public static SortBy asc(String propertyName) {
        return Predicates.sortBy(propertyName, true);
    }

    public static SortBy desc(String propertyName) {
        return Predicates.sortBy(propertyName, false);
    }

    public static SortBy sortBy(String propertyName, boolean ascending) {
        return factory.sort(propertyName, ascending ? SortOrder.ASCENDING : SortOrder.DESCENDING);
    }

    public static Filter isInstanceOf(Class<?> clazz) {
        return factory.equals((Expression)factory.function("isInstanceOf", new Expression[]{factory.literal(clazz)}), (Expression)factory.literal(true));
    }

    public static Filter notEqual(String property, Object expected) {
        return factory.notEqual((Expression)factory.property(property), (Expression)factory.literal(expected));
    }

    public static Filter in(String propertyName, List<? extends Object> values) {
        ArrayList<PropertyName> arguments = new ArrayList<PropertyName>();
        arguments.add(factory.property(propertyName));
        values.stream().map(v -> factory.literal(v)).forEach(l -> arguments.add((PropertyName)l));
        Function in = factory.function("in", arguments.toArray(new Expression[arguments.size()]));
        return factory.equals((Expression)in, (Expression)factory.literal(true));
    }
}

