/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.NamedStyle;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.UserLayer;
import org.geotools.brewer.styling.builder.StyledLayerDescriptorBuilder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;

public class Styles {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms");
    static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);

    public static String string(StyledLayerDescriptor sld, SLDHandler handler, Version ver, boolean pretty) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        handler.encode(sld, ver, pretty, bout);
        return new String(bout.toByteArray());
    }

    public static Style style(StyledLayerDescriptor sld) {
        for (int i = 0; i < sld.getStyledLayers().length; ++i) {
            Style[] styles = null;
            StyledLayer styledLayer = sld.getStyledLayers()[i];
            if (styledLayer instanceof NamedLayer) {
                NamedLayer layer = (NamedLayer)styledLayer;
                styles = layer.getStyles();
            } else {
                styledLayer = sld.getStyledLayers()[i];
                if (styledLayer instanceof UserLayer) {
                    UserLayer layer = (UserLayer)styledLayer;
                    styles = layer.getUserStyles();
                }
            }
            if (styles == null) continue;
            for (Style style : styles) {
                if (style instanceof NamedStyle) continue;
                return style;
            }
        }
        return null;
    }

    public static StyledLayerDescriptor sld(Style style) {
        StyledLayerDescriptorBuilder sldBuilder = new StyledLayerDescriptorBuilder();
        sldBuilder.namedLayer().name(style.getName()).style().reset(style);
        return sldBuilder.build();
    }

    public static StyleHandler handler(String format) {
        if (format == null) {
            throw new IllegalArgumentException("Style format must not be null");
        }
        List<StyleHandler> allHandlers = Styles.handlers();
        ArrayList<StyleHandler> matches = new ArrayList<StyleHandler>();
        for (StyleHandler h : allHandlers) {
            if (!format.equalsIgnoreCase(h.getFormat())) continue;
            matches.add(h);
        }
        if (matches.isEmpty()) {
            for (StyleHandler h : allHandlers) {
                for (Version ver : h.getVersions()) {
                    if (!h.mimeType(ver).equals(format)) continue;
                    matches.add(h);
                }
            }
        }
        if (matches.isEmpty()) {
            for (StyleHandler h : allHandlers) {
                if (!format.equalsIgnoreCase(h.getFileExtension())) continue;
                matches.add(h);
            }
        }
        if (matches.isEmpty()) {
            throw new RuntimeException("No such style handler: format = " + format);
        }
        if (matches.size() == 1) {
            return (StyleHandler)matches.get(0);
        }
        List handlerNames = Lists.transform(matches, (Function)new Function<StyleHandler, String>(){

            @Nullable
            public String apply(@Nullable StyleHandler styleHandler) {
                if (styleHandler == null) {
                    throw new RuntimeException("Got a null style handler, unexpected");
                }
                return styleHandler.getName();
            }
        });
        throw new IllegalArgumentException("Multiple style handlers: " + String.valueOf(handlerNames) + " found for format: " + format);
    }

    public static List<StyleHandler> handlers() {
        return GeoServerExtensions.extensions(StyleHandler.class);
    }
}

