/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.http.HTTPClient;

public class TestHttpClientProvider {
    public static final String MOCKSERVER = "http://mock.test.geoserver.org";
    static final Map<String, HTTPClient> CLIENTS = new ConcurrentHashMap<String, HTTPClient>();
    private static boolean TEST_MODE = false;

    public static void bind(HTTPClient client, URL url) {
        TestHttpClientProvider.bind(client, url.toExternalForm());
    }

    public static void bind(HTTPClient client, String url) {
        if (!url.startsWith(MOCKSERVER)) {
            throw new IllegalArgumentException("The URL must start with http://mock.test.geoserver.org");
        }
        CLIENTS.put(url, client);
    }

    public static HTTPClient get(String url) {
        if (!url.startsWith(MOCKSERVER)) {
            throw new IllegalArgumentException("The url " + url + " does not start with http://mock.test.geoserver.org");
        }
        if (!TEST_MODE) {
            throw new IllegalArgumentException("The provider is not in test mode now");
        }
        HTTPClient httpClient = CLIENTS.get(url);
        if (httpClient == null) {
            throw new IllegalArgumentException("The mock url " + url + " is not bound to any mock http client, current bindings are towards: " + String.valueOf(CLIENTS.keySet()));
        }
        return httpClient;
    }

    public static boolean isTestModeEnabled() {
        return TEST_MODE;
    }

    public static void clear() {
        CLIENTS.clear();
    }

    public static void endTest() {
        TEST_MODE = false;
        CLIENTS.clear();
    }

    public static void startTest() {
        TEST_MODE = true;
    }
}

