/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.GeoServerDefaultLocale;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.util.InternationalString;
import org.geotools.data.transform.Definition;
import org.geotools.data.transform.TransformFactory;
import org.geotools.feature.FeatureTypes;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;

public class TransformFeatureTypeCallback {
    public FeatureType retypeFeatureType(FeatureTypeInfo fti, FeatureType schema) throws IOException {
        List<AttributeTypeInfo> attributes = fti.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            return schema;
        }
        SimpleFeatureSource fs = this.getDataStore(fti).getFeatureSource(fti.getNativeName());
        SimpleFeatureSource tfs = this.getTransformedSource(fti, attributes, fs);
        return tfs.getSchema();
    }

    public <T extends FeatureType, U extends Feature> FeatureSource<T, U> wrapFeatureSource(FeatureTypeInfo fti, FeatureSource<T, U> fs) throws IOException {
        List<AttributeTypeInfo> attributes = fti.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            return fs;
        }
        return this.getTransformedSource(fti, attributes, (SimpleFeatureSource)fs);
    }

    private SimpleFeatureSource getTransformedSource(FeatureTypeInfo fti, List<AttributeTypeInfo> attributes, SimpleFeatureSource fs) throws IOException {
        List definitions = attributes.stream().map(ati -> this.toDefinition((AttributeTypeInfo)ati)).collect(Collectors.toList());
        SimpleFeatureSource tfs = TransformFactory.transform((SimpleFeatureSource)fs, (String)fti.getName(), definitions);
        return tfs;
    }

    private DataStore getDataStore(FeatureTypeInfo fti) throws IOException {
        DataAccess<? extends FeatureType, ? extends Feature> da = fti.getStore().getDataStore(null);
        if (da instanceof DataStore) {
            DataStore store = (DataStore)da;
            return store;
        }
        throw new ServiceException("Cannot apply feature type customization on complex features, the server is mis-configured");
    }

    private Definition toDefinition(AttributeTypeInfo ati) {
        try {
            String name = ati.getName();
            Expression source = ECQL.toExpression((String)ati.getSource());
            Class<?> binding = ati.getBinding();
            InternationalString descriptionInternational = this.createDescriptionInternationalString(ati);
            boolean nillable = ati.isNillable();
            List<Filter> restrictions = this.createRestrictions(ati);
            return new Definition(name, source, binding, null, descriptionInternational, nillable, restrictions);
        }
        catch (CQLException e) {
            throw new ServiceException("Failed to parse the attribute source definition to a valid OGC Expression", (Throwable)e);
        }
    }

    private InternationalString createDescriptionInternationalString(AttributeTypeInfo ati) {
        Object descriptionInternational = ati.getDescription();
        if (descriptionInternational != null) {
            String description = StringUtils.trimToNull((String)ati.getDescription().toString(GeoServerDefaultLocale.get()));
            descriptionInternational = description != null ? new SimpleInternationalString(description) : null;
        }
        return descriptionInternational;
    }

    private List<Filter> createRestrictions(AttributeTypeInfo ati) {
        List<Object> options;
        ArrayList<Filter> restrictions = new ArrayList<Filter>();
        NumberRange<? extends Number> range = ati.getRange();
        if (range != null) {
            Filter fieldMinMax = FeatureTypes.createFieldRange(range);
            restrictions.add(fieldMinMax);
        }
        if ((options = ati.getOptions()) != null) {
            Filter fieldOptions = FeatureTypes.createFieldOptions(options);
            restrictions.add(fieldOptions);
        }
        return restrictions;
    }
}

