/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.List;
import java.util.Objects;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.util.InternationalStringUtils;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.util.InternationalString;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.NumberRange;

public class AttributeTypeInfoImpl
implements AttributeTypeInfo {
    protected String id;
    protected String name;
    protected int minOccurs;
    protected int maxOccurs;
    protected Boolean nillable;
    protected transient AttributeDescriptor attribute;
    protected MetadataMap metadata = new MetadataMap();
    protected FeatureTypeInfo featureType;
    protected Class<?> binding;
    protected Integer length;
    protected NumberRange<? extends Number> range;
    protected List<Object> options;
    protected String source;
    protected GrowableInternationalString description;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    @Override
    public boolean isNillable() {
        return this.nillable == null || this.nillable != false;
    }

    @Override
    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    @Override
    public FeatureTypeInfo getFeatureType() {
        return this.featureType;
    }

    @Override
    public void setFeatureType(FeatureTypeInfo featureType) {
        this.featureType = featureType;
    }

    @Override
    public AttributeDescriptor getAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(AttributeDescriptor attribute) {
        this.attribute = attribute;
    }

    public MetadataMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataMap metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Class<?> getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Class<?> binding) {
        this.binding = binding;
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public void setLength(Integer length) {
        this.length = length;
    }

    @Override
    public NumberRange<? extends Number> getRange() {
        return this.range;
    }

    @Override
    public void setRange(NumberRange<? extends Number> range) {
        this.range = range;
    }

    @Override
    public List<Object> getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(List<Object> options) {
        this.options = options;
    }

    @Override
    public String getRawSource() {
        return this.source;
    }

    @Override
    public String getSource() {
        if (this.source == null && this.name != null) {
            return AttributeTypeInfoImpl.needsQuoting(this.name) ? "\"" + this.name + "\"" : this.name;
        }
        return this.source;
    }

    private static boolean needsQuoting(String name) {
        if (name.contains(".")) {
            return true;
        }
        try {
            if (!(ECQL.toExpression((String)name) instanceof PropertyName)) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    public GrowableInternationalString getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(InternationalString description) {
        this.description = InternationalStringUtils.growable(description);
    }

    public boolean equals(Object o) {
        return this.equalsIgnoreFeatureType(o) && Objects.equals(this.featureType, ((AttributeTypeInfoImpl)o).featureType);
    }

    public int hashCode() {
        String source = this.source == null ? this.name : this.source;
        return Objects.hash(this.id, this.name, this.minOccurs, this.maxOccurs, this.isNillable(), this.attribute, this.metadata, this.binding, this.length, this.description, this.range, this.options, source);
    }

    @Override
    public boolean equalsIgnoreFeatureType(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeTypeInfoImpl that = (AttributeTypeInfoImpl)o;
        return this.minOccurs == that.minOccurs && this.maxOccurs == that.maxOccurs && Objects.equals(this.isNillable(), that.isNillable()) && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.attribute, that.attribute) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.binding, that.binding) && Objects.equals(this.length, that.length) && Objects.equals(this.description, that.description) && Objects.equals(this.range, that.range) && Objects.equals(this.options, that.options) && (Objects.equals(this.source, that.source) || Objects.equals(this.getSource(), that.getSource()));
    }
}

