/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogBeforeAddEvent;
import org.geoserver.catalog.event.CatalogEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.platform.ExtensionPriority;
import org.geotools.util.logging.Logging;

public class CatalogEventDispatcher {
    private static final Logger LOGGER = Logging.getLogger(CatalogImpl.class);
    protected List<CatalogListener> listeners = new CopyOnWriteArrayList<CatalogListener>();

    public Collection<CatalogListener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public void addListener(CatalogListener listener) {
        this.listeners.add(listener);
        Collections.sort(this.listeners, ExtensionPriority.COMPARATOR);
    }

    public void removeListener(CatalogListener listener) {
        this.listeners.remove(listener);
    }

    public void removeListeners(Class<? extends CatalogListener> listenerClass) {
        new ArrayList<CatalogListener>(this.listeners).stream().filter(l -> listenerClass.isInstance(l)).forEach(l -> this.listeners.remove(l));
    }

    public void dispatch(CatalogEvent event) {
        CatalogException toThrow = null;
        for (CatalogListener listener : this.listeners) {
            try {
                if (event instanceof CatalogAddEvent) {
                    CatalogAddEvent addEvent1 = (CatalogAddEvent)event;
                    listener.handleAddEvent(addEvent1);
                    continue;
                }
                if (event instanceof CatalogRemoveEvent) {
                    CatalogRemoveEvent removeEvent = (CatalogRemoveEvent)event;
                    listener.handleRemoveEvent(removeEvent);
                    continue;
                }
                if (event instanceof CatalogModifyEvent) {
                    CatalogModifyEvent modifyEvent1 = (CatalogModifyEvent)event;
                    listener.handleModifyEvent(modifyEvent1);
                    continue;
                }
                if (event instanceof CatalogPostModifyEvent) {
                    CatalogPostModifyEvent modifyEvent = (CatalogPostModifyEvent)event;
                    listener.handlePostModifyEvent(modifyEvent);
                    continue;
                }
                if (!(event instanceof CatalogBeforeAddEvent)) continue;
                CatalogBeforeAddEvent addEvent = (CatalogBeforeAddEvent)event;
                listener.handlePreAddEvent(addEvent);
            }
            catch (Throwable t) {
                if (t instanceof CatalogException) {
                    CatalogException exception = (CatalogException)t;
                    if (toThrow == null) {
                        toThrow = exception;
                        continue;
                    }
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "Catalog listener threw exception handling event.", t);
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public void syncTo(CatalogEventDispatcher dispatcher) {
        dispatcher.listeners = this.listeners;
    }
}

