/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.PropertyUtils;
import org.geoserver.catalog.Info;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.ClassMappings;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

public class CatalogPropertyAccessor
implements PropertyAccessor {
    private static final Logger LOGGER = Logging.getLogger(CatalogPropertyAccessor.class);
    private static Map<Class<?>, Set<String>> FULL_TEXT_PROPERTIES = Maps.newHashMap();

    public boolean canHandle(Object object, String xpath, Class<?> target) {
        return object instanceof Info;
    }

    public <T> void set(Object object, String xpath, T value, Class<T> target) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public <T> T get(Object object, String xpath, Class<T> target) throws IllegalArgumentException {
        Object value = this.getProperty(object, xpath);
        Object result = null != target && null != value ? Converters.convert((Object)value, target) : value;
        return (T)result;
    }

    public Object getProperty(Object input, String propertyName) throws IllegalArgumentException {
        Info info;
        if (input instanceof Info) {
            info = (Info)input;
            if (Predicates.ANY_TEXT.getPropertyName().equals(propertyName)) {
                return this.getAnyText(info);
            }
        }
        if (input instanceof Info) {
            info = (Info)input;
            if ("id".equals(propertyName)) {
                return info.getId();
            }
        }
        String[] propertyNames = propertyName.split("\\.");
        return this.getProperty(input, propertyNames, 0);
    }

    private List<String> getAnyText(Info input) {
        Set<String> propNames = CatalogPropertyAccessor.fullTextProperties(input);
        ArrayList<String> textProps = new ArrayList<String>(propNames.size());
        for (String propName : propNames) {
            Object property = this.getProperty(input, propName);
            if (property instanceof Collection) {
                textProps.addAll((Collection)property);
                continue;
            }
            if (property == null) continue;
            textProps.add(String.valueOf(property));
        }
        return textProps;
    }

    public Object getProperty(Object input, String[] propertyNames, int offset) throws IllegalArgumentException {
        Object value;
        if (offset < 0 || offset > propertyNames.length) {
            throw new ArrayIndexOutOfBoundsException("offset: " + offset + ", properties: " + propertyNames.length);
        }
        if (offset == propertyNames.length) {
            return input;
        }
        String propName = propertyNames[offset];
        if (null == input) {
            throw new IllegalArgumentException("Property not found: " + Joiner.on((char)'.').join((Object[])Arrays.copyOf(propertyNames, offset + 1)));
        }
        if (propName.indexOf(91) > 0 && propName.endsWith("]")) {
            return this.getIndexedProperty(input, propertyNames, offset);
        }
        if (input instanceof Collection) {
            Collection col = (Collection)input;
            ArrayList<Object> result = new ArrayList<Object>(col.size());
            for (Object o : col) {
                if (o == null) continue;
                try {
                    Object value2 = this.getProperty(o, propName);
                    Object nested = this.getProperty(value2, propertyNames, offset + 1);
                    result.add(nested);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Skipping nested property not found", e);
                }
            }
            return result;
        }
        if (input instanceof Map) {
            Map map = (Map)input;
            if (!map.containsKey(propName)) {
                throw new IllegalArgumentException("Property " + propName + " does not exist in Map property " + (offset > 0 ? propertyNames[offset - 1] : ""));
            }
            value = map.get(propName);
        } else if ("boundingBox".equalsIgnoreCase(propName) && input instanceof ResourceInfo) {
            ResourceInfo info = (ResourceInfo)input;
            try {
                value = info.boundingBox();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            value = OwsUtils.get((Object)input, (String)propName);
        }
        if (value == null) {
            return null;
        }
        return this.getProperty(value, propertyNames, offset + 1);
    }

    private Object getIndexedProperty(Object input, String[] propertyNames, int offset) {
        Object indexedValue;
        int endIndex;
        String indexedPropName = propertyNames[offset];
        String colPropName = indexedPropName.substring(0, indexedPropName.indexOf(91));
        int beginIndex = indexedPropName.indexOf(91) + 1;
        String indexStr = indexedPropName.substring(beginIndex, endIndex = indexedPropName.length() - 1);
        int index = Integer.parseInt(indexStr);
        Preconditions.checkArgument((index > 0 ? 1 : 0) != 0, (Object)("Illegal indexed property, index shall be > 0: " + indexedPropName));
        Collection<Object> col = this.getCollectionProperty(input, colPropName);
        if (col == null) {
            try {
                indexedValue = PropertyUtils.getIndexedProperty((Object)input, (String)colPropName, (int)(index - 1));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                indexedValue = null;
            }
        } else {
            if (!(col instanceof List)) {
                throw new RuntimeException("Indexed property access is not valid for property " + colPropName);
            }
            List list2 = (List)col;
            if (index > list2.size()) {
                return null;
            }
            indexedValue = list2.get(index - 1);
        }
        return indexedValue == null ? Boolean.valueOf(false) : this.getProperty(indexedValue, propertyNames, offset + 1);
    }

    private Collection<Object> getCollectionProperty(Object input, String colPropName) {
        ArrayList<Object> colProp;
        if (input instanceof Map) {
            Map map = (Map)input;
            colProp = map.get(colPropName);
        } else {
            try {
                colProp = OwsUtils.get((Object)input, (String)colPropName);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (null == colProp) {
            return null;
        }
        if (colProp.getClass().isArray()) {
            int length = Array.getLength(colProp);
            ArrayList<Object> array = new ArrayList<Object>(length);
            for (int j = 0; j < length; ++j) {
                array.add(Array.get(colProp, j));
            }
            colProp = array;
        }
        if (!(colProp instanceof Collection)) {
            throw new IllegalArgumentException("Specified property " + colPropName + " is not a collection or array: " + String.valueOf(colProp));
        }
        Collection col = colProp;
        return col;
    }

    private static Set<String> fullTextProperties(Info obj) {
        Object props = ImmutableSet.of();
        if (obj != null) {
            Class<?> clazz = ModificationProxy.unwrap(obj).getClass();
            ClassMappings classMappings = ClassMappings.fromImpl(clazz);
            Preconditions.checkState((classMappings != null ? 1 : 0) != 0, (Object)("No class mappings found for class " + clazz.getName()));
            Class<? extends Info> interf = classMappings.getInterface();
            props = CatalogPropertyAccessor.fullTextProperties(interf);
        }
        return props;
    }

    public static Set<String> fullTextProperties(Class<?> type) {
        ImmutableSet props;
        if (FULL_TEXT_PROPERTIES.isEmpty()) {
            CatalogPropertyAccessor.loadFullTextProperties();
        }
        if ((props = FULL_TEXT_PROPERTIES.get(type)) == null) {
            props = ImmutableSet.of();
        }
        return props;
    }

    private static synchronized void loadFullTextProperties() {
        if (!FULL_TEXT_PROPERTIES.isEmpty()) {
            return;
        }
        String resource = "CatalogPropertyAccessor_FullTextProperties.properties";
        Properties properties = new Properties();
        try (InputStream stream = CatalogPropertyAccessor.class.getResourceAsStream("CatalogPropertyAccessor_FullTextProperties.properties");){
            properties.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ImmutableMap map = Maps.fromProperties((Properties)properties);
        for (Map.Entry e : map.entrySet()) {
            Class<?> key;
            try {
                key = Class.forName((String)e.getKey());
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
            String[] split = ((String)e.getValue()).split(",");
            HashSet set = Sets.newHashSet();
            for (String s : split) {
                set.add(s.trim());
            }
            FULL_TEXT_PROPERTIES.put(key, (Set<String>)ImmutableSet.copyOf((Collection)set));
        }
    }
}

