/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.util.InternationalStringUtils;
import org.geotools.api.util.InternationalString;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.GrowableInternationalString;

public class LayerGroupInfoImpl
implements LayerGroupInfo {
    protected String id;
    protected String name;
    protected LayerGroupInfo.Mode mode = LayerGroupInfo.Mode.SINGLE;
    protected Boolean queryDisabled;
    protected String title;
    protected String abstractTxt;
    protected Boolean enabled;
    protected Boolean advertised;
    protected WorkspaceInfo workspace;
    protected String path;
    protected LayerInfo rootLayer;
    protected StyleInfo rootLayerStyle;
    protected GrowableInternationalString internationalTitle;
    protected GrowableInternationalString internationalAbstract;
    protected List<LayerInfo> layers = new ArrayList<LayerInfo>();
    protected List<PublishedInfo> publishables = new ArrayList<PublishedInfo>();
    protected List<StyleInfo> styles = new ArrayList<StyleInfo>();
    protected List<MetadataLinkInfo> metadataLinks = new ArrayList<MetadataLinkInfo>();
    protected ReferencedEnvelope bounds;
    protected MetadataMap metadata = new MetadataMap();
    protected AttributionInfo attribution;
    protected List<AuthorityURLInfo> authorityURLs = new ArrayList<AuthorityURLInfo>(2);
    protected List<LayerIdentifierInfo> identifiers = new ArrayList<LayerIdentifierInfo>(2);
    private List<KeywordInfo> keywords = new ArrayList<KeywordInfo>();
    protected Date dateCreated;
    protected Date dateModified;
    protected String modifiedBy;
    protected List<LayerGroupStyle> layerGroupStyles = new ArrayList<LayerGroupStyle>();

    @Override
    public List<KeywordInfo> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<KeywordInfo> keywords) {
        this.keywords = keywords == null ? new ArrayList() : keywords;
    }

    public LayerGroupInfoImpl() {
        this.mode = LayerGroupInfo.Mode.SINGLE;
        this.publishables = new ArrayList<PublishedInfo>();
        this.styles = new ArrayList<StyleInfo>();
        this.metadata = new MetadataMap();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public LayerGroupInfo.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(LayerGroupInfo.Mode mode) {
        this.mode = mode;
    }

    @Override
    public boolean isEnabled() {
        if (this.enabled != null) {
            return this.enabled;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isQueryDisabled() {
        return this.queryDisabled != null ? this.queryDisabled : false;
    }

    @Override
    public void setQueryDisabled(boolean queryDisabled) {
        this.queryDisabled = queryDisabled ? Boolean.TRUE : null;
    }

    @Override
    public String getTitle() {
        String result = InternationalStringUtils.getOrDefault(this.title, (InternationalString)this.internationalTitle);
        if (result == null && this.metadata != null) {
            result = this.title = this.metadata.get("title", String.class);
        }
        return result;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean isAdvertised() {
        if (this.advertised != null) {
            return this.advertised;
        }
        return true;
    }

    @Override
    public void setAdvertised(boolean advertised) {
        this.advertised = advertised;
    }

    @Override
    public String getAbstract() {
        String result = InternationalStringUtils.getOrDefault(this.abstractTxt, (InternationalString)this.internationalAbstract);
        if (result == null && this.metadata != null) {
            result = this.abstractTxt = this.metadata.get("title", String.class);
        }
        return result;
    }

    @Override
    public void setAbstract(String abstractTxt) {
        this.abstractTxt = abstractTxt;
    }

    @Override
    public WorkspaceInfo getWorkspace() {
        return this.workspace;
    }

    @Override
    public void setWorkspace(WorkspaceInfo workspace) {
        this.workspace = workspace;
    }

    @Override
    public String prefixedName() {
        return this.workspace != null ? this.workspace.getName() + ":" + this.name : this.name;
    }

    @Override
    public LayerInfo getRootLayer() {
        return this.rootLayer;
    }

    @Override
    public void setRootLayer(LayerInfo rootLayer) {
        this.rootLayer = rootLayer;
    }

    @Override
    public StyleInfo getRootLayerStyle() {
        return this.rootLayerStyle;
    }

    @Override
    public void setRootLayerStyle(StyleInfo style) {
        this.rootLayerStyle = style;
    }

    @Override
    public List<PublishedInfo> getLayers() {
        return this.publishables;
    }

    public void setLayers(List<PublishedInfo> publishables) {
        this.publishables = publishables;
    }

    public void convertLegacyLayers() {
        if (this.layers != null && this.publishables == null) {
            this.publishables = new ArrayList<PublishedInfo>();
            for (LayerInfo layer : this.layers) {
                this.publishables.add(layer);
            }
            this.layers = null;
        }
    }

    @Override
    public List<StyleInfo> getStyles() {
        return this.styles;
    }

    public void setStyles(List<StyleInfo> styles) {
        this.styles = styles;
    }

    @Override
    public List<LayerInfo> layers() {
        LayerGroupHelper helper = new LayerGroupHelper(this);
        return helper.allLayersForRendering();
    }

    @Override
    public List<StyleInfo> styles() {
        LayerGroupHelper helper = new LayerGroupHelper(this);
        return helper.allStylesForRendering();
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(ReferencedEnvelope bounds) {
        this.bounds = bounds;
    }

    @Override
    public MetadataMap getMetadata() {
        this.checkMetadataNotNull();
        return this.metadata;
    }

    public void setMetadata(MetadataMap metadata) {
        this.metadata = metadata;
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        return LayerGroupInfo.hashCode(this);
    }

    public boolean equals(Object obj) {
        return LayerGroupInfo.equals(this, obj);
    }

    @Override
    public List<AuthorityURLInfo> getAuthorityURLs() {
        return this.authorityURLs;
    }

    public void setAuthorityURLs(List<AuthorityURLInfo> authorities) {
        this.authorityURLs = authorities;
    }

    @Override
    public List<LayerIdentifierInfo> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<LayerIdentifierInfo> identifiers) {
        this.identifiers = identifiers;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.name + ']';
    }

    public String getPrefixedName() {
        return this.prefixedName();
    }

    @Override
    public PublishedType getType() {
        return PublishedType.GROUP;
    }

    @Override
    public AttributionInfo getAttribution() {
        return this.attribution;
    }

    @Override
    public void setAttribution(AttributionInfo attribution) {
        this.attribution = attribution;
    }

    @Override
    public List<MetadataLinkInfo> getMetadataLinks() {
        return this.metadataLinks;
    }

    public void setMetadataLinks(List<MetadataLinkInfo> metadataLinks) {
        this.metadataLinks = metadataLinks;
    }

    @Override
    public Date getDateModified() {
        return this.dateModified;
    }

    @Override
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    private void checkMetadataNotNull() {
        if (this.metadata == null) {
            this.metadata = new MetadataMap();
        }
    }

    public GrowableInternationalString getInternationalTitle() {
        return this.internationalTitle;
    }

    @Override
    public void setInternationalTitle(InternationalString internationalTitle) {
        this.internationalTitle = InternationalStringUtils.growable(internationalTitle);
    }

    public GrowableInternationalString getInternationalAbstract() {
        return this.internationalAbstract;
    }

    @Override
    public void setInternationalAbstract(InternationalString internationalAbstract) {
        this.internationalAbstract = InternationalStringUtils.growable(internationalAbstract);
    }

    @Override
    public List<LayerInfo> layers(String layerGroupStyleName) {
        LayerGroupHelper helper = new LayerGroupHelper(this);
        return helper.allLayersForRendering(layerGroupStyleName);
    }

    @Override
    public List<StyleInfo> styles(String layerGroupStyleName) {
        LayerGroupHelper helper = new LayerGroupHelper(this);
        return helper.allStylesForRendering(layerGroupStyleName);
    }

    @Override
    public List<LayerGroupStyle> getLayerGroupStyles() {
        if (this.layerGroupStyles == null) {
            this.layerGroupStyles = new ArrayList<LayerGroupStyle>();
        }
        return this.layerGroupStyles;
    }

    @Override
    public void setLayerGroupStyles(List<LayerGroupStyle> styles) {
        this.layerGroupStyles = styles;
    }

    @Override
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public void setModifiedBy(String userModified) {
        this.modifiedBy = userModified;
    }
}

