/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.impl.CatalogInfoLookup;
import org.geoserver.catalog.impl.DefaultCatalogFacade;
import org.geoserver.catalog.impl.ModificationProxy;

class NamespaceInfoLookup
extends CatalogInfoLookup<NamespaceInfo> {
    private ConcurrentHashMap<String, List<NamespaceInfo>> index = new ConcurrentHashMap();
    private static Comparator<NamespaceInfo> VALUE_ORDER = (n1, n2) -> n1.getId().compareTo(n2.getId());

    public NamespaceInfoLookup() {
        super(DefaultCatalogFacade.NAMESPACE_NAME_MAPPER);
    }

    public List<NamespaceInfo> findAllByUri(String uri) {
        this.lock.readLock().lock();
        try {
            List<NamespaceInfo> list2 = List.copyOf(this.valueList(uri, false));
            return list2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public NamespaceInfoLookup setCatalog(Catalog catalog) {
        super.setCatalog(catalog);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamespaceInfo add(NamespaceInfo value) {
        this.writeLock.lock();
        try {
            NamespaceInfo ns = super.add(value);
            this.addInternal(value);
            NamespaceInfo namespaceInfo = ns;
            return namespaceInfo;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void addInternal(NamespaceInfo value) {
        List<NamespaceInfo> values = this.valueList(value.getURI(), true);
        values.add(ModificationProxy.unwrap(value));
        values.sort(VALUE_ORDER);
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            super.clear();
            this.index.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamespaceInfo remove(NamespaceInfo value) {
        this.writeLock.lock();
        try {
            String uri = value.getURI();
            NamespaceInfo ns = super.remove(value);
            this.removeInternal(value, uri);
            NamespaceInfo namespaceInfo = ns;
            return namespaceInfo;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void removeInternal(NamespaceInfo value, String uri) {
        List<NamespaceInfo> list2 = this.valueList(uri, false);
        if (!list2.isEmpty()) {
            list2.remove(ModificationProxy.unwrap(value));
        }
        if (list2.isEmpty()) {
            this.index.remove(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(NamespaceInfo value) {
        this.writeLock.lock();
        try {
            ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(value);
            NamespaceInfo actualValue = (NamespaceInfo)h.getProxyObject();
            String oldUri = actualValue.getURI();
            String newUri = value.getURI();
            boolean uriChanged = !Objects.equals(oldUri, newUri);
            super.update(value);
            if (uriChanged) {
                this.removeInternal(value, oldUri);
                this.addInternal(value);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    List<NamespaceInfo> valueList(String uri, boolean create) {
        if (create) {
            return this.index.computeIfAbsent(uri, v -> new ArrayList());
        }
        return this.index.getOrDefault(uri, List.of());
    }
}

