/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ProxyBase
implements InvocationHandler {
    private volatile HashMap<String, Object> properties;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ((method.getName().startsWith("get") || method.getName().startsWith("is")) && method.getParameterTypes().length == 0) {
            String property = method.getName().substring(method.getName().startsWith("get") ? 3 : 2);
            return this.handleGet(proxy, method, property);
        }
        if (method.getName().startsWith("set") && args.length == 1) {
            String property = method.getName().substring(3);
            this.handleSet(proxy, method, args[0], property);
            return null;
        }
        return this.handleOther(proxy, method, args);
    }

    protected Object handleGet(Object proxy, Method method, String property) throws Throwable {
        if (this.properties != null && this.properties().containsKey(property)) {
            return this.properties().get(property);
        }
        return this.handleGetUnSet(proxy, method, property);
    }

    protected Object handleGetUnSet(Object proxy, Method method, String property) throws Throwable {
        return method.invoke(proxy, new Object[0]);
    }

    protected void handleSet(Object proxy, Method method, Object value, String property) throws Throwable {
        this.properties().put(property, value);
    }

    protected Object handleOther(Object proxy, Method method, Object[] args) throws Throwable {
        return method.invoke(proxy, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap<String, Object> properties() {
        if (this.properties != null) {
            return this.properties;
        }
        ProxyBase proxyBase = this;
        synchronized (proxyBase) {
            if (this.properties != null) {
                return this.properties;
            }
            this.properties = new HashMap();
        }
        return this.properties;
    }
}

