/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataLinkInfo;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.util.InternationalStringUtils;
import org.geotools.api.feature.type.Name;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.InternationalString;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public abstract class ResourceInfoImpl
implements ResourceInfo {
    static final Logger LOGGER = Logging.getLogger(ResourceInfoImpl.class);
    protected String id;
    protected String name;
    protected String nativeName;
    protected List<String> alias = new ArrayList<String>();
    protected NamespaceInfo namespace;
    protected String title;
    protected String description;
    protected String _abstract;
    protected List<KeywordInfo> keywords = new ArrayList<KeywordInfo>();
    protected List<MetadataLinkInfo> metadataLinks = new ArrayList<MetadataLinkInfo>();
    protected List<DataLinkInfo> dataLinks = new ArrayList<DataLinkInfo>();
    protected CoordinateReferenceSystem nativeCRS;
    protected String srs;
    protected ReferencedEnvelope nativeBoundingBox;
    protected ReferencedEnvelope latLonBoundingBox;
    protected ProjectionPolicy projectionPolicy;
    protected boolean enabled;
    protected Boolean advertised;
    protected MetadataMap metadata = new MetadataMap();
    protected StoreInfo store;
    protected boolean serviceConfiguration = false;
    protected List<String> disabledServices = new ArrayList<String>();
    protected Boolean simpleConversionEnabled = false;
    protected transient Catalog catalog;
    protected GrowableInternationalString internationalTitle;
    protected GrowableInternationalString internationalAbstract;

    protected ResourceInfoImpl() {
    }

    protected ResourceInfoImpl(Catalog catalog) {
        this.catalog = catalog;
    }

    protected ResourceInfoImpl(Catalog catalog, String id) {
        this(catalog);
        this.setId(id);
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Name getQualifiedName() {
        return new NameImpl(this.getNamespace().getURI(), this.getName());
    }

    @Override
    public String getNativeName() {
        return this.nativeName;
    }

    @Override
    public void setNativeName(String nativeName) {
        this.nativeName = nativeName;
    }

    @Override
    public Name getQualifiedNativeName() {
        return new NameImpl(this.getNamespace().getURI(), this.getNativeName());
    }

    @Override
    public NamespaceInfo getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(NamespaceInfo namespace) {
        this.namespace = namespace;
    }

    @Override
    public String prefixedName() {
        return this.getNamespace().getPrefix() + ":" + this.getName();
    }

    @Override
    public String getTitle() {
        return InternationalStringUtils.getOrDefault(this.title, (InternationalString)this.internationalTitle);
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getAbstract() {
        return InternationalStringUtils.getOrDefault(this._abstract, (InternationalString)this.internationalAbstract);
    }

    @Override
    public void setAbstract(String _abstract) {
        this._abstract = _abstract;
    }

    @Override
    public List<KeywordInfo> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<KeywordInfo> keywords) {
        this.keywords = keywords;
    }

    @Override
    public List<String> keywordValues() {
        ArrayList<String> values = new ArrayList<String>();
        if (this.keywords != null) {
            for (KeywordInfo kw : this.keywords) {
                values.add(kw.getValue());
            }
        }
        return values;
    }

    @Override
    public List<MetadataLinkInfo> getMetadataLinks() {
        return this.metadataLinks;
    }

    @Override
    public List<DataLinkInfo> getDataLinks() {
        return this.dataLinks;
    }

    @Override
    public String getSRS() {
        return this.srs;
    }

    @Override
    public void setSRS(String srs) {
        this.srs = srs;
    }

    @Override
    public ReferencedEnvelope boundingBox() throws Exception {
        CoordinateReferenceSystem declaredCRS = this.getCRS();
        CoordinateReferenceSystem nativeCRS = this.getNativeCRS();
        ProjectionPolicy php = this.getProjectionPolicy();
        ReferencedEnvelope nativeBox = this.getNativeBoundingBox();
        if (nativeBox == null) {
            try {
                if (declaredCRS == null) {
                    LOGGER.log(Level.WARNING, "Failed to derive native bbox, there is no declared CRS provided");
                    return null;
                }
                nativeBox = this.getLatLonBoundingBox().transform(declaredCRS, true);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to derive native bbox from declared one", e);
                return null;
            }
        } else if (nativeBox.getCoordinateReferenceSystem() == null) {
            if (nativeCRS != null) {
                nativeBox = ReferencedEnvelope.create((Bounds)nativeBox, (CoordinateReferenceSystem)nativeCRS);
            }
        } else if (nativeCRS != null && !CRS.equalsIgnoreMetadata((Object)nativeBox.getCoordinateReferenceSystem(), (Object)nativeCRS)) {
            LOGGER.log(Level.FINE, "The native bounding box srs does not match native crs");
        }
        if (!(php != ProjectionPolicy.REPROJECT_TO_DECLARED || CRS.equalsIgnoreMetadata((Object)declaredCRS, (Object)nativeCRS) && ResourceInfoImpl.nativeCRSHasIdentifiers(nativeCRS))) {
            if (nativeBox.getCoordinateReferenceSystem() == null) {
                LOGGER.log(Level.WARNING, "Unable to reproject to declared crs (native bounding box srs and native crs are not defined)");
                return null;
            }
            return nativeBox.transform(declaredCRS, true);
        }
        if (php == ProjectionPolicy.FORCE_DECLARED) {
            return ReferencedEnvelope.envelope((Envelope)nativeBox, (CoordinateReferenceSystem)declaredCRS);
        }
        if (nativeBox == null || nativeBox.getCoordinateReferenceSystem() == null) {
            LOGGER.log(Level.WARNING, "Unable to determine native bounding crs (both native bounding box srs and native crs are not defined)");
        }
        return ReferencedEnvelope.create((ReferencedEnvelope)nativeBox);
    }

    private static boolean nativeCRSHasIdentifiers(CoordinateReferenceSystem nativeCRS) {
        return Optional.ofNullable(nativeCRS).map(IdentifiedObject::getIdentifiers).filter(c -> !c.isEmpty()).isPresent();
    }

    @Override
    public ReferencedEnvelope getLatLonBoundingBox() {
        return this.latLonBoundingBox;
    }

    @Override
    public void setLatLonBoundingBox(ReferencedEnvelope box) {
        this.latLonBoundingBox = box;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean enabled() {
        StoreInfo store = this.getStore();
        boolean storeEnabled = store != null && store.isEnabled();
        return storeEnabled && this.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public MetadataMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataMap metaData) {
        this.metadata = metaData;
    }

    public void setMetadataLinks(List<MetadataLinkInfo> metaDataLinks) {
        this.metadataLinks = metaDataLinks;
    }

    public void setDataLinks(List<DataLinkInfo> dataLinks) {
        this.dataLinks = dataLinks;
    }

    @Override
    public StoreInfo getStore() {
        return this.store;
    }

    StoreInfo rawStore() {
        return this.store;
    }

    @Override
    public void setStore(StoreInfo store) {
        this.store = store;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterClass, Map<?, ?> hints) {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }

    @Override
    public List<String> getAlias() {
        return this.alias;
    }

    public void setAlias(List<String> alias) {
        this.alias = alias;
    }

    @Override
    public CoordinateReferenceSystem getCRS() {
        if (this.getSRS() == null) {
            return null;
        }
        try {
            return CRS.decode((String)this.getSRS());
        }
        catch (Exception e) {
            throw new RuntimeException("This is unexpected, the layer srs seems to be mis-configured", e);
        }
    }

    @Override
    public ReferencedEnvelope getNativeBoundingBox() {
        return this.nativeBoundingBox;
    }

    @Override
    public void setNativeBoundingBox(ReferencedEnvelope box) {
        this.nativeBoundingBox = box;
    }

    @Override
    public CoordinateReferenceSystem getNativeCRS() {
        return this.nativeCRS;
    }

    @Override
    public void setNativeCRS(CoordinateReferenceSystem nativeCRS) {
        this.nativeCRS = nativeCRS;
    }

    @Override
    public ProjectionPolicy getProjectionPolicy() {
        return this.projectionPolicy;
    }

    @Override
    public void setProjectionPolicy(ProjectionPolicy projectionPolicy) {
        this.projectionPolicy = projectionPolicy;
    }

    @Override
    public boolean isAdvertised() {
        if (this.advertised != null) {
            return this.advertised;
        }
        MetadataMap md = this.getMetadata();
        if (md == null) {
            return true;
        }
        Boolean metadataAdvertised = md.get("advertised", Boolean.class);
        if (metadataAdvertised == null) {
            metadataAdvertised = true;
        }
        return metadataAdvertised;
    }

    @Override
    public void setAdvertised(boolean advertised) {
        this.advertised = advertised;
    }

    @Override
    public boolean isServiceConfiguration() {
        return this.serviceConfiguration;
    }

    @Override
    public void setServiceConfiguration(boolean serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }

    @Override
    public List<String> getDisabledServices() {
        return this.disabledServices;
    }

    @Override
    public void setDisabledServices(List<String> disabledServices) {
        this.disabledServices = disabledServices;
    }

    @Override
    public boolean isSimpleConversionEnabled() {
        return this.simpleConversionEnabled == null ? false : this.simpleConversionEnabled;
    }

    @Override
    public void setSimpleConversionEnabled(boolean simpleConversionEnabled) {
        this.simpleConversionEnabled = simpleConversionEnabled;
    }

    public GrowableInternationalString getInternationalTitle() {
        return this.internationalTitle;
    }

    @Override
    public void setInternationalTitle(InternationalString internationalTitle) {
        this.internationalTitle = InternationalStringUtils.growable(internationalTitle);
    }

    public GrowableInternationalString getInternationalAbstract() {
        return this.internationalAbstract;
    }

    @Override
    public void setInternationalAbstract(InternationalString internationalAbstract) {
        this.internationalAbstract = InternationalStringUtils.growable(internationalAbstract);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._abstract == null ? 0 : this._abstract.hashCode());
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.keywords == null ? 0 : this.keywords.hashCode());
        result = 31 * result + (this.latLonBoundingBox == null ? 0 : this.latLonBoundingBox.hashCode());
        result = 31 * result + (this.metadataLinks == null ? 0 : this.metadataLinks.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.nativeBoundingBox == null ? 0 : this.nativeBoundingBox.hashCode());
        result = 31 * result + (this.nativeCRS == null ? 0 : this.nativeCRS.hashCode());
        result = 31 * result + (this.nativeName == null ? 0 : this.nativeName.hashCode());
        result = 31 * result + (this.projectionPolicy == null ? 0 : this.projectionPolicy.hashCode());
        result = 31 * result + (this.srs == null ? 0 : this.srs.hashCode());
        result = 31 * result + (this.store == null ? 0 : this.store.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceInfo)) {
            return false;
        }
        ResourceInfo other = (ResourceInfo)obj;
        if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
            return false;
        }
        if (this.getAbstract() == null ? other.getAbstract() != null : !this.getAbstract().equals(other.getAbstract())) {
            return false;
        }
        if (this.alias == null ? other.getAlias() != null : !this.alias.equals(other.getAlias())) {
            return false;
        }
        if (this.description == null ? other.getDescription() != null : !this.description.equals(other.getDescription())) {
            return false;
        }
        if (this.enabled != other.isEnabled()) {
            return false;
        }
        if (this.keywords == null ? other.getKeywords() != null : !this.keywords.equals(other.getKeywords())) {
            return false;
        }
        if (this.latLonBoundingBox == null ? other.getLatLonBoundingBox() != null : !this.latLonBoundingBox.equals((Object)other.getLatLonBoundingBox())) {
            return false;
        }
        if (this.metadataLinks == null ? other.getMetadataLinks() != null : !this.metadataLinks.equals(other.getMetadataLinks())) {
            return false;
        }
        if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
            return false;
        }
        if (this.namespace == null ? other.getNamespace() != null : !this.namespace.equals(other.getNamespace())) {
            return false;
        }
        if (this.nativeBoundingBox == null ? other.getNativeBoundingBox() != null : !this.nativeBoundingBox.equals((Object)other.getNativeBoundingBox())) {
            return false;
        }
        if (this.nativeCRS == null ? other.getNativeCRS() != null : !CRS.equalsIgnoreMetadata((Object)this.nativeCRS, (Object)other.getNativeCRS())) {
            return false;
        }
        if (this.nativeName == null ? other.getNativeName() != null : !this.nativeName.equals(other.getNativeName())) {
            return false;
        }
        if (this.projectionPolicy == null ? other.getProjectionPolicy() != null : !this.projectionPolicy.equals((Object)other.getProjectionPolicy())) {
            return false;
        }
        if (this.srs == null ? other.getSRS() != null : !this.srs.equals(other.getSRS())) {
            return false;
        }
        if (this.store == null ? other.getStore() != null : !this.store.equals(other.getStore())) {
            return false;
        }
        return !(this.getTitle() == null ? other.getTitle() != null : !this.getTitle().equals(other.getTitle()));
    }
}

