/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.datadir;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.datadir.XStreamLoader;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;
import org.springframework.lang.NonNull;

class DataDirectoryWalker {
    private static final Logger LOGGER = Logging.getLogger((String)DataDirectoryWalker.class.getPackage().getName());
    private final GeoServerDataDirectory dataDirectory;
    private final XStreamLoader xstreamLoader;
    private final List<XStreamServiceLoader<ServiceInfo>> serviceLoaders;
    private final List<String> serviceFileNames;
    private GeoServerConfigurationLock configLock;
    private List<WorkspaceDirectory> workspaces;

    public DataDirectoryWalker(GeoServerDataDirectory dataDirectory, XStreamPersisterFactory xpf, GeoServerConfigurationLock configLock) {
        this(dataDirectory, xpf, configLock, DataDirectoryWalker.findServiceLoaders());
    }

    DataDirectoryWalker(GeoServerDataDirectory dataDirectory, XStreamPersisterFactory xpf, GeoServerConfigurationLock configLock, List<?> serviceLoaders) {
        this.dataDirectory = dataDirectory;
        this.configLock = configLock;
        this.xstreamLoader = new XStreamLoader(xpf);
        this.serviceLoaders = serviceLoaders.stream().map(l -> (XStreamServiceLoader)l).collect(Collectors.toList());
        this.serviceFileNames = this.serviceLoaders.stream().map(XStreamServiceLoader::getFilename).collect(Collectors.toList());
    }

    public List<XStreamServiceLoader<ServiceInfo>> getServiceLoaders() {
        return this.serviceLoaders;
    }

    private static List<XStreamServiceLoader<ServiceInfo>> findServiceLoaders() {
        return GeoServerExtensions.extensions(XStreamServiceLoader.class);
    }

    public GeoServerDataDirectory getDataDirectory() {
        return this.dataDirectory;
    }

    public XStreamLoader getXStreamLoader() {
        return this.xstreamLoader;
    }

    public void lock() {
        this.getConfigurationLock().lock(GeoServerConfigurationLock.LockType.WRITE);
    }

    public void unlock() {
        this.getConfigurationLock().unlock();
    }

    public GeoServerConfigurationLock getConfigurationLock() {
        return this.configLock;
    }

    public Path getRoot() {
        return this.dataDirectory.root().toPath();
    }

    private Stream<LayerDirectory> layers(Path storeDirectory) {
        return this.subdirectories(storeDirectory).stream().map(this::newLayer).flatMap(Optional::stream);
    }

    private Optional<LayerDirectory> newLayer(Path layerDirectory) {
        Path layerFile = layerDirectory.resolve("layer.xml");
        if (Files.isRegularFile(layerFile, new LinkOption[0])) {
            return Stream.of("featuretype.xml", "coverage.xml", "wmslayer.xml", "wmtslayer.xml").map(layerDirectory::resolve).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().map(resourceFile -> new LayerDirectory((Path)resourceFile, layerFile));
        }
        return Optional.empty();
    }

    private static boolean storeDirnameFilter(Path dir) {
        String name = dir.getFileName().toString();
        return !"styles".equals(name) && !"layergroups".equals(name);
    }

    private Stream<StoreDirectory> stores(Path workspaceDir) {
        return this.subdirectories(workspaceDir).stream().filter(DataDirectoryWalker::storeDirnameFilter).map(this::newStore).flatMap(Optional::stream);
    }

    private Optional<StoreDirectory> newStore(Path directory) {
        return Stream.of("datastore.xml", "coveragestore.xml", "wmsstore.xml", "wmtsstore.xml").map(directory::resolve).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().map(storeFile -> new StoreDirectory((Path)storeFile, this));
    }

    public List<Path> globalStyles() {
        return this.childXmlFiles(this.getRoot().resolve("styles"));
    }

    public List<Path> globalLayerGroups() {
        return this.childXmlFiles(this.getRoot().resolve("layergroups"));
    }

    public List<WorkspaceDirectory> workspaces() {
        if (this.workspaces == null) {
            Path workspacesRoot = this.workspacesRoot();
            List<Path> workspaceDirectories = this.subdirectories(workspacesRoot);
            this.workspaces = ((Stream)workspaceDirectories.stream().parallel()).map(this::newWorkspace).filter(Optional::isPresent).map(Optional::orElseThrow).collect(Collectors.toList());
        }
        return this.workspaces;
    }

    private Path workspacesRoot() {
        return this.getRoot().resolve("workspaces");
    }

    public Optional<Path> gsGlobal() {
        return this.optionalFile(this.getRoot().resolve("global.xml"));
    }

    public Optional<Path> gsLogging() {
        return this.optionalFile(this.getRoot().resolve("logging.xml"));
    }

    public Optional<Path> defaultWorkspace() {
        return this.optionalFile(this.getDefaultWorkspaceFile());
    }

    public Path getDefaultWorkspaceFile() {
        return this.workspacesRoot().resolve("default.xml");
    }

    private Optional<Path> optionalFile(Path file) {
        boolean exists = Files.isRegularFile(file, new LinkOption[0]);
        return Optional.ofNullable(exists ? file : null);
    }

    private Optional<WorkspaceDirectory> newWorkspace(Path wsdir) {
        return WorkspaceDirectory.newInstance(wsdir, this);
    }

    private List<Path> subdirectories(Path parent) {
        return this.children(parent, (Path x$0) -> Files.isDirectory(x$0, new LinkOption[0]));
    }

    private List<Path> childXmlFiles(Path parent) {
        return this.children(parent, "*.xml");
    }

    private List<Path> children(Path parent, String glob) {
        if (Files.isDirectory(parent, new LinkOption[0])) {
            List<Path> list2;
            block9: {
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(parent, glob);
                try {
                    list2 = this.toList(directoryStream);
                    if (directoryStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (directoryStream != null) {
                            try {
                                directoryStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                directoryStream.close();
            }
            return list2;
        }
        return Collections.emptyList();
    }

    private List<Path> children(Path parent, DirectoryStream.Filter<Path> filter) {
        if (Files.isDirectory(parent, new LinkOption[0])) {
            List<Path> list2;
            block9: {
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(parent, filter);
                try {
                    list2 = this.toList(directoryStream);
                    if (directoryStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (directoryStream != null) {
                            try {
                                directoryStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                directoryStream.close();
            }
            return list2;
        }
        return Collections.emptyList();
    }

    private List<Path> toList(Iterable<Path> children) {
        return Lists.newArrayList(children);
    }

    static class WorkspaceDirectory {
        @NonNull
        private final Path directory;
        @NonNull
        private final DataDirectoryWalker walker;
        private Set<String> serviceInfoFileNames = Set.of();

        private WorkspaceDirectory(Path directory, DataDirectoryWalker walker) {
            Objects.requireNonNull(directory);
            Objects.requireNonNull(walker);
            this.directory = directory;
            this.walker = walker;
        }

        public static Optional<WorkspaceDirectory> newInstance(Path workspaceDirectory, DataDirectoryWalker fileWalk) {
            WorkspaceDirectory wd = new WorkspaceDirectory(workspaceDirectory, fileWalk);
            Path ws = wd.workspaceFile();
            Path ns = wd.namespaceFile();
            boolean wsExists = Files.isRegularFile(ws, new LinkOption[0]);
            boolean nsExists = Files.isRegularFile(ns, new LinkOption[0]);
            if (wsExists && nsExists) {
                List<String> availableServiceFileNames = fileWalk.serviceFileNames;
                wd.serviceInfoFileNames = availableServiceFileNames.stream().filter(f -> Files.isRegularFile(workspaceDirectory.resolve((String)f), new LinkOption[0])).collect(Collectors.toSet());
                return Optional.of(wd);
            }
            if (!wsExists) {
                LOGGER.severe("workspace.xml missing at " + String.valueOf(workspaceDirectory));
            }
            if (!nsExists) {
                LOGGER.severe("namespace.xml missing at " + String.valueOf(workspaceDirectory) + " ignoring workspace");
            }
            return Optional.empty();
        }

        public Path directory() {
            return this.directory;
        }

        public Path workspaceFile() {
            return this.directory.resolve("workspace.xml");
        }

        public Path namespaceFile() {
            return this.directory.resolve("namespace.xml");
        }

        public Optional<Path> settingsFile() {
            return Optional.of(this.directory.resolve("settings.xml")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
        }

        public Set<String> serviceInfoFileNames() {
            return this.serviceInfoFileNames;
        }

        public Stream<StoreDirectory> stores() {
            return this.walker.stores(this.directory);
        }

        public List<Path> styles() {
            return this.walker.childXmlFiles(this.directory.resolve("styles"));
        }

        public List<Path> layerGroups() {
            return this.walker.childXmlFiles(this.directory.resolve("layergroups"));
        }
    }

    static class StoreDirectory {
        @NonNull
        public final Path storeFile;
        @NonNull
        private DataDirectoryWalker walker;

        public StoreDirectory(Path storeFile, DataDirectoryWalker walker) {
            Objects.requireNonNull(storeFile);
            Objects.requireNonNull(walker);
            this.storeFile = storeFile;
            this.walker = walker;
        }

        public Stream<LayerDirectory> layers() {
            Path parent = Optional.ofNullable(this.storeFile.getParent()).orElseThrow(NullPointerException::new);
            return this.walker.layers(parent);
        }
    }

    static class LayerDirectory {
        @NonNull
        public final Path resourceFile;
        @NonNull
        public final Path layerFile;

        public LayerDirectory(Path resourceFile, Path layerFile) {
            Objects.requireNonNull(resourceFile);
            Objects.requireNonNull(layerFile);
            this.resourceFile = resourceFile;
            this.layerFile = layerFile;
        }
    }
}

