/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.impl;

import java.util.Collection;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.impl.MetadataLinkInfoImpl;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFactory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ImageProcessingInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.config.impl.ImageProcessingInfoImpl;
import org.geoserver.config.impl.LoggingInfoImpl;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.config.impl.SettingsInfoImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GeoServerFactoryImpl
implements GeoServerFactory,
ApplicationContextAware {
    GeoServer gs;
    ApplicationContext applicationContext;

    public GeoServerFactoryImpl(GeoServer gs) {
        this.gs = gs;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public GeoServerInfo createGlobal() {
        return new GeoServerInfoImpl(this.gs);
    }

    @Override
    public SettingsInfo createSettings() {
        return new SettingsInfoImpl();
    }

    @Override
    public ContactInfo createContact() {
        return new ContactInfoImpl();
    }

    @Override
    public ImageProcessingInfo createJAI() {
        return new ImageProcessingInfoImpl();
    }

    @Override
    public MetadataLinkInfo createMetadataLink() {
        return new MetadataLinkInfoImpl();
    }

    @Override
    public ServiceInfo createService() {
        return new ServiceInfoImpl();
    }

    @Override
    public LoggingInfo createLogging() {
        return new LoggingInfoImpl();
    }

    @Override
    public <T> T create(Class<T> clazz) {
        if (this.applicationContext != null) {
            Collection extensions = this.applicationContext.getBeansOfType(GeoServerFactory.Extension.class).values();
            for (Object o : extensions) {
                GeoServerFactory.Extension extension = (GeoServerFactory.Extension)o;
                if (!extension.canCreate(clazz)) continue;
                return extension.create(clazz);
            }
        }
        return null;
    }
}

