/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.impl;

import java.io.Serializable;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.TileCache;
import org.geoserver.config.ImageProcessingInfo;

public class ImageProcessingInfoImpl
implements Serializable,
ImageProcessingInfo {
    public static final String KEY = "jai.info";
    private static final long serialVersionUID = 7121137497699361776L;
    boolean allowInterpolation;
    public static final boolean DEFAULT_Recycling = false;
    boolean recycling = false;
    public static final int DEFAULT_TilePriority = 5;
    int tilePriority = 5;
    public static final int DEFAULT_TileThreads = 7;
    int tileThreads = 7;
    public static final double DEFAULT_MemoryCapacity = 0.5;
    double memoryCapacity = 0.5;
    public static final double DEFAULT_MemoryThreshold = 0.75;
    double memoryThreshold = 0.75;
    public static final boolean DEFAULT_ImageIOCache = false;
    boolean imageIOCache = false;
    ImageProcessingInfo.PngEncoderType pngEncoderType = ImageProcessingInfo.PngEncoderType.PNGJ;

    @Override
    public boolean getAllowInterpolation() {
        return this.allowInterpolation;
    }

    @Override
    public void setAllowInterpolation(boolean allowInterpolation) {
        this.allowInterpolation = allowInterpolation;
    }

    @Override
    public boolean isRecycling() {
        return this.recycling;
    }

    @Override
    public void setRecycling(boolean recycling) {
        this.recycling = recycling;
    }

    @Override
    public int getTilePriority() {
        return this.tilePriority;
    }

    @Override
    public void setTilePriority(int tilePriority) {
        this.tilePriority = tilePriority;
    }

    @Override
    public int getTileThreads() {
        return this.tileThreads;
    }

    @Override
    public void setTileThreads(int tileThreads) {
        this.tileThreads = tileThreads;
    }

    @Override
    public double getMemoryCapacity() {
        return this.memoryCapacity;
    }

    @Override
    public void setMemoryCapacity(double memoryCapacity) {
        this.memoryCapacity = memoryCapacity;
    }

    @Override
    public double getMemoryThreshold() {
        return this.memoryThreshold;
    }

    @Override
    public void setMemoryThreshold(double memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public void setImageIOCache(boolean imageIOCache) {
        this.imageIOCache = imageIOCache;
    }

    public boolean isImageIOCache() {
        return this.imageIOCache;
    }

    @Override
    public ImageN getImageProcessing() {
        return ImageN.getDefaultInstance();
    }

    @Override
    public void setImageProcessing(ImageN imagen) {
    }

    @Override
    public TileCache getTileCache() {
        return this.getImageProcessing().getTileCache();
    }

    @Override
    public void setTileCache(TileCache tileCache) {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowInterpolation ? 1231 : 1237);
        result = 31 * result + (this.imageIOCache ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.memoryCapacity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.memoryThreshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.recycling ? 1231 : 1237);
        result = 31 * result + this.tilePriority;
        result = 31 * result + this.tileThreads;
        result = 31 * result + this.getPngEncoderType().hashCode();
        result = 31 * result + this.getPngEncoderType().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageProcessingInfoImpl other = (ImageProcessingInfoImpl)obj;
        if (this.allowInterpolation != other.allowInterpolation) {
            return false;
        }
        if (this.imageIOCache != other.imageIOCache) {
            return false;
        }
        if (Double.doubleToLongBits(this.memoryCapacity) != Double.doubleToLongBits(other.memoryCapacity)) {
            return false;
        }
        if (Double.doubleToLongBits(this.memoryThreshold) != Double.doubleToLongBits(other.memoryThreshold)) {
            return false;
        }
        if (this.recycling != other.recycling) {
            return false;
        }
        if (this.tilePriority != other.tilePriority) {
            return false;
        }
        if (this.tileThreads != other.tileThreads) {
            return false;
        }
        return this.getPngEncoderType() == other.getPngEncoderType();
    }

    @Override
    public ImageProcessingInfoImpl clone() {
        try {
            return (ImageProcessingInfoImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImageProcessingInfo.PngEncoderType getPngEncoderType() {
        if (this.pngEncoderType == null) {
            return ImageProcessingInfo.PngEncoderType.PNGJ;
        }
        return this.pngEncoderType;
    }

    @Override
    public void setPngEncoderType(ImageProcessingInfo.PngEncoderType pngEncoderType) {
        this.pngEncoderType = pngEncoderType;
    }
}

