/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.enums.EnumConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

public final class EnumWithDefaultConverter
extends EnumConverter {
    private final Enum<?> defaultValue;

    public EnumWithDefaultConverter(Enum<?> defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class type = context.getRequiredType();
        if (type.getSuperclass() != Enum.class) {
            type = type.getSuperclass();
        }
        String name = reader.getValue();
        try {
            return Enum.valueOf(type, name);
        }
        catch (IllegalArgumentException ignore) {
            for (Enum c : (Enum[])type.getEnumConstants()) {
                if (!c.name().equalsIgnoreCase(name)) continue;
                return c;
            }
            return this.defaultValue;
        }
    }
}

