/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFactory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.ImageProcessingInfoImpl;
import org.geoserver.config.util.LegacyServiceLoader;
import org.geoserver.config.util.LegacyServicesReader;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;

public class LegacyConfigurationImporter {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.confg");
    GeoServer geoServer;

    public LegacyConfigurationImporter(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public LegacyConfigurationImporter() {
    }

    public void setConfiguration(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public GeoServer getConfiguration() {
        return this.geoServer;
    }

    public void imprt(File dir) throws Exception {
        GeoServerFactory factory = this.geoServer.getFactory();
        File servicesFile = new File(dir, "services.xml");
        if (!servicesFile.exists()) {
            throw new FileNotFoundException("Could not find services.xml under:" + dir.getAbsolutePath());
        }
        LegacyServicesReader reader = new LegacyServicesReader();
        reader.read(servicesFile);
        GeoServerInfo info = factory.createGlobal();
        Map<String, Object> global = reader.global();
        info.getSettings().setVerbose(this.get(global, "verbose", Boolean.TYPE));
        info.getSettings().setVerboseExceptions(this.get(global, "verboseExceptions", Boolean.TYPE));
        info.getSettings().setNumDecimals(this.get(global, "numDecimals", Integer.TYPE, 4));
        info.getSettings().setCharset((String)global.get("charSet"));
        info.setUpdateSequence(this.get(global, "updateSequence", Integer.TYPE).longValue());
        info.getSettings().setOnlineResource(this.get(global, "onlineResource", String.class));
        info.getSettings().setProxyBaseUrl(this.get(global, "ProxyBaseUrl", String.class));
        Map<String, Object> contact = reader.contact();
        ContactInfo contactInfo = factory.createContact();
        contactInfo.setContactPerson((String)contact.get("ContactPerson"));
        contactInfo.setContactOrganization((String)contact.get("ContactOrganization"));
        contactInfo.setContactVoice((String)contact.get("ContactVoiceTelephone"));
        contactInfo.setContactFacsimile((String)contact.get("ContactFacsimileTelephone"));
        contactInfo.setContactPosition((String)contact.get("ContactPosition"));
        contactInfo.setContactEmail((String)contact.get("ContactElectronicMailAddress"));
        contactInfo.setAddress((String)contact.get("Address"));
        contactInfo.setAddressType((String)contact.get("AddressType"));
        contactInfo.setAddressCity((String)contact.get("City"));
        contactInfo.setAddressCountry((String)contact.get("Country"));
        contactInfo.setAddressState((String)contact.get("StateOrProvince"));
        contactInfo.setAddressPostalCode((String)contact.get("PostCode"));
        info.getSettings().setContact(contactInfo);
        ImageProcessingInfoImpl imagen = new ImageProcessingInfoImpl();
        imagen.setMemoryCapacity((Double)this.value(global.get("JaiMemoryCapacity"), 0.5));
        imagen.setMemoryThreshold((Double)this.value(global.get("JaiMemoryThreshold"), 0.75));
        imagen.setTileThreads((Integer)this.value(global.get("JaiTileThreads"), 7));
        imagen.setTilePriority((Integer)this.value(global.get("JaiTilePriority"), 5));
        imagen.setRecycling((Boolean)this.value(global.get("JaiRecycling"), false));
        info.setImageProcessing(imagen);
        this.geoServer.setGlobal(info);
        LoggingInfo logging = factory.createLogging();
        logging.setLevel((String)global.get("log4jConfigFile"));
        logging.setLocation((String)global.get("logLocation"));
        if (global.get("suppressStdOutLogging") != null) {
            logging.setStdOutLogging(this.get(global, "suppressStdOutLogging", Boolean.class) == false);
        } else {
            logging.setStdOutLogging(true);
        }
        this.geoServer.setLogging(logging);
        for (LegacyServiceLoader sl : GeoServerExtensions.extensions(LegacyServiceLoader.class)) {
            try {
                sl.setReader(reader);
                Object service = sl.load(this.geoServer);
                if (service == null) continue;
                LOGGER.config("Loading service '" + service.getId() + "'");
                this.geoServer.add((ServiceInfo)service);
            }
            catch (Exception e) {
                String msg = "Error occured loading service: " + sl.getServiceClass().getSimpleName();
                LOGGER.warning(msg);
                LOGGER.log(Level.INFO, "", e);
            }
        }
    }

    Object value(Object value, Object def) {
        return value != null ? value : def;
    }

    protected <T> T get(Map map, String key, Class<T> clazz, T def) {
        Object o = map.get(key);
        if (o == null) {
            if (def != null) {
                return def;
            }
            if (clazz.isPrimitive()) {
                if (clazz == Integer.TYPE) {
                    return (T)Integer.valueOf(0);
                }
                if (clazz == Double.TYPE) {
                    return (T)Double.valueOf(0.0);
                }
                if (clazz == Boolean.TYPE) {
                    return (T)Boolean.FALSE;
                }
            }
            return null;
        }
        return (T)o;
    }

    protected <T> T get(Map map, String key, Class<T> clazz) {
        return this.get(map, key, clazz, null);
    }
}

