/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.crs;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.geotools.referencing.CRS;

public class CapabilitiesCRSProvider {
    private static Set<String> DEFAULT_AUTHORITY_EXCLUSIONS = Set.of("http://www.opengis.net/gml", "http://www.opengis.net/def", "AUTO", "AUTO2", "urn:ogc:def", "urn:x-ogc:def");
    private BiFunction<String, String, String> codeMapper = CapabilitiesCRSProvider::mapCode;
    private Set<String> authorityExclusions = new HashSet<String>(DEFAULT_AUTHORITY_EXCLUSIONS);
    private BiFunction<String, String, Boolean> codeFilter = CapabilitiesCRSProvider::filterCode;

    public Set<String> getAuthorityExclusions() {
        return this.authorityExclusions;
    }

    public Set<String> getCodes() {
        List authorities = CRS.getSupportedAuthorities((boolean)true).stream().filter(a -> !this.authorityExclusions.contains(a)).sorted().collect(Collectors.toList());
        return authorities.stream().flatMap(authority -> CRS.getSupportedCodes((String)authority).stream().filter(code -> this.codeFilter.apply((String)authority, (String)code)).sorted((a, b) -> this.compareCodes((String)a, (String)b)).map(code -> this.codeMapper.apply((String)authority, (String)code))).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    private int compareCodes(String a, String b) {
        try {
            return Integer.valueOf(a).compareTo(Integer.valueOf(b));
        }
        catch (NumberFormatException e) {
            return a.compareTo(b);
        }
    }

    public void setCodeMapper(BiFunction<String, String, String> codeMapper) {
        this.codeMapper = codeMapper;
    }

    public void setCodeFilter(BiFunction<String, String, Boolean> codeFilter) {
        this.codeFilter = codeFilter;
    }

    private static String mapCode(String authority, String code) {
        return authority + ":" + code;
    }

    private static boolean filterCode(String authority, String code) {
        return !"WGS84(DD)".equals(code);
    }
}

