/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.util.ReaderUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CatalogReader {
    Element catalog;

    public void read(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            this.catalog = ReaderUtils.parse((Reader)reader);
        }
    }

    public List<Map<String, String>> dataStores() throws Exception {
        Element dataStoresElement = ReaderUtils.getChildElement((Element)this.catalog, (String)"datastores", (boolean)true);
        NodeList dataStoreElements = dataStoresElement.getElementsByTagName("datastore");
        ArrayList<Map<String, String>> dataStores = new ArrayList<Map<String, String>>();
        for (int i = 0; i < dataStoreElements.getLength(); ++i) {
            Element dataStoreElement = (Element)dataStoreElements.item(i);
            try {
                Map<String, String> params = this.dataStoreParams(dataStoreElement);
                dataStores.add(params);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return dataStores;
    }

    public Map<String, String> namespaces() throws Exception {
        Element namespacesElement = ReaderUtils.getChildElement((Element)this.catalog, (String)"namespaces", (boolean)true);
        NodeList namespaceElements = namespacesElement.getElementsByTagName("namespace");
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int i = 0; i < namespaceElements.getLength(); ++i) {
            Element namespaceElement = (Element)namespaceElements.item(i);
            try {
                Map.Entry<String, String> tuple = this.namespaceTuple(namespaceElement);
                namespaces.put(tuple.getKey(), tuple.getValue());
                if (!"true".equals(namespaceElement.getAttribute("default"))) continue;
                namespaces.put("", tuple.getValue());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return namespaces;
    }

    protected Map<String, String> dataStoreParams(Element dataStoreElement) throws Exception {
        Element paramsElement = ReaderUtils.getChildElement((Element)dataStoreElement, (String)"connectionParameters", (boolean)true);
        NodeList paramList = paramsElement.getElementsByTagName("parameter");
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < paramList.getLength(); ++i) {
            Element paramElement = (Element)paramList.item(i);
            String key = ReaderUtils.getAttribute((Element)paramElement, (String)"name", (boolean)true);
            String value = ReaderUtils.getAttribute((Element)paramElement, (String)"value", (boolean)true);
            params.put(key, value);
        }
        return params;
    }

    protected Map.Entry<String, String> namespaceTuple(Element namespaceElement) throws Exception {
        String pre = namespaceElement.getAttribute("prefix");
        String uri = namespaceElement.getAttribute("uri");
        return new AbstractMap.SimpleEntry<String, String>(pre, uri);
    }
}

