/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CatalogWriter {
    Document document;
    Element catalog;
    public static final String COVERAGE_TYPE_KEY = "coverageType";
    public static final String COVERAGE_URL_KEY = "coverageUrl";

    public CatalogWriter() {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(false);
            builderFactory.setValidating(false);
            this.document = builderFactory.newDocumentBuilder().newDocument();
            this.catalog = this.document.createElement("catalog");
            this.document.appendChild(this.catalog);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void dataStores(Map dataStores, Map namespaces, Set disabled) {
        Element dataStoresElement = this.document.createElement("datastores");
        this.catalog.appendChild(dataStoresElement);
        Iterator iterator = dataStores.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item;
            Map.Entry dataStore = item = iterator.next();
            String id = (String)dataStore.getKey();
            Map params = (Map)dataStore.getValue();
            Element dataStoreElement = this.document.createElement("datastore");
            dataStoresElement.appendChild(dataStoreElement);
            dataStoreElement.setAttribute("id", id);
            dataStoreElement.setAttribute("enabled", Boolean.toString(!disabled.contains(id)));
            dataStoreElement.setAttribute("namespace", (String)namespaces.get(id));
            Element connectionParamtersElement = this.document.createElement("connectionParams");
            dataStoreElement.appendChild(connectionParamtersElement);
            Iterator iterator2 = params.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry o;
                Map.Entry param = o = iterator2.next();
                String name = (String)param.getKey();
                Object value = param.getValue();
                if (value == null) continue;
                Element parameterElement = this.document.createElement("parameter");
                connectionParamtersElement.appendChild(parameterElement);
                parameterElement.setAttribute("name", name);
                parameterElement.setAttribute("value", value.toString());
            }
        }
    }

    public void coverageStores(HashMap coverageStores, HashMap namespaces, Set disabled) {
        Element formatsElement = this.document.createElement("formats");
        this.catalog.appendChild(formatsElement);
        Iterator iterator = coverageStores.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry dataStore = o = iterator.next();
            String id = (String)dataStore.getKey();
            Map params = (Map)dataStore.getValue();
            Element formatElement = this.document.createElement("format");
            formatsElement.appendChild(formatElement);
            formatElement.setAttribute("id", id);
            formatElement.setAttribute("enabled", Boolean.toString(!disabled.contains(id)));
            formatElement.setAttribute("namespace", (String)namespaces.get(id));
            Element typeElement = this.document.createElement("type");
            formatElement.appendChild(typeElement);
            typeElement.setTextContent((String)params.get(COVERAGE_TYPE_KEY));
            Element urlElement = this.document.createElement("url");
            formatElement.appendChild(urlElement);
            urlElement.setTextContent((String)params.get(COVERAGE_URL_KEY));
        }
    }

    public void namespaces(Map namespaces) {
        this.namespaces(namespaces, Collections.emptyList());
    }

    public void namespaces(Map namespaces, List<String> isolatedNamespaces) {
        Element namespacesElement = this.document.createElement("namespaces");
        this.catalog.appendChild(namespacesElement);
        Iterator iterator = namespaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry namespace = o = iterator.next();
            String prefix = (String)namespace.getKey();
            String uri = (String)namespace.getValue();
            if ("".equals(prefix)) continue;
            Element namespaceElement = this.document.createElement("namespace");
            namespacesElement.appendChild(namespaceElement);
            namespaceElement.setAttribute("uri", uri);
            namespaceElement.setAttribute("prefix", prefix);
            if (uri.equals(namespaces.get(""))) {
                namespaceElement.setAttribute("default", "true");
            }
            if (!isolatedNamespaces.contains(prefix)) continue;
            namespaceElement.setAttribute("isolated", "true");
        }
    }

    public void styles(Map styles) {
        Element stylesElement = this.document.createElement("styles");
        this.catalog.appendChild(stylesElement);
        Iterator iterator = styles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry style = o = iterator.next();
            String id = (String)style.getKey();
            String filename = (String)style.getValue();
            Element styleElement = this.document.createElement("style");
            stylesElement.appendChild(styleElement);
            styleElement.setAttribute("id", id);
            styleElement.setAttribute("filename", filename);
        }
    }

    public void write(File file) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);){
            Transformer tx = TransformerFactory.newInstance().newTransformer();
            tx.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(os);
            tx.transform(source, result);
        }
        catch (Exception e) {
            String msg = "Could not write catalog to " + String.valueOf(file);
            throw new IOException(msg, e);
        }
    }
}

