/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.jdbc.datasource.UnWrapper;
import org.geotools.util.logging.Logging;

public class GenericUnWrapper
implements UnWrapper {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.data.jdbc.GenericUnWrapper");
    private static final Method IGNORE;
    static final Map<Class<?>, Method> CONNECTION_METHODS;
    static final Map<Class<?>, Method> STATEMENT_METHODS;

    private static void methodSearch(String env, Map<Class<?>, Method> methods, String className, String methodName) {
        try {
            Class<?> wrappedConnection = Class.forName(className);
            Method unwrap = wrappedConnection.getMethod(methodName, null);
            LOGGER.info(env + " " + className + " supported");
            methods.put(wrappedConnection, unwrap);
        }
        catch (ClassNotFoundException ignore) {
            LOGGER.finer(env + " " + className + " not found");
        }
        catch (Throwable e) {
            LOGGER.fine(env + " " + className + " not available:" + String.valueOf(e));
        }
    }

    public static void ignore() {
    }

    public boolean canUnwrap(Connection conn) {
        Connection unwrapped = this.unwrapInternal(Connection.class, conn, CONNECTION_METHODS);
        return unwrapped != null;
    }

    public Connection unwrap(Connection conn) {
        Connection unwrapped = this.unwrapInternal(Connection.class, conn, CONNECTION_METHODS);
        if (unwrapped != null) {
            return unwrapped;
        }
        throw new IllegalArgumentException("This connection is not unwrappable, check canUnwrap before calling unwrap");
    }

    public boolean canUnwrap(Statement statement) {
        Statement unwrapped = this.unwrapInternal(Statement.class, statement, STATEMENT_METHODS);
        return unwrapped != null;
    }

    public Statement unwrap(Statement statement) {
        Statement unwrapped = this.unwrapInternal(Statement.class, statement, STATEMENT_METHODS);
        if (unwrapped != null) {
            return unwrapped;
        }
        throw new IllegalArgumentException("This statement is not unwrappable, check canUnwrap before calling unwrap");
    }

    private <T> T unwrapInternal(Class<T> target, T conn, Map<Class<?>, Method> methods) {
        T unwrapped;
        Class<?> implementation = conn.getClass();
        if (methods.containsKey(implementation)) {
            Method accessMethod = methods.get(implementation);
            if (accessMethod == IGNORE) {
                return null;
            }
            T unwrapped2 = this.unwrapInternal(target, conn, implementation, accessMethod);
            return unwrapped2;
        }
        for (Map.Entry<Class<?>, Method> entry : methods.entrySet()) {
            Class<?> wrapper = entry.getKey();
            Method accessMethod = entry.getValue();
            if (!wrapper.isInstance(conn) || (unwrapped = this.unwrapInternal(target, conn, wrapper, accessMethod)) == null) continue;
            methods.put(implementation, accessMethod);
            return unwrapped;
        }
        for (Method method : implementation.getMethods()) {
            if (!target.isAssignableFrom(method.getReturnType()) || method.getParameterTypes().length != 0 || !method.isAccessible() || (unwrapped = this.unwrapInternal(target, conn, implementation, method)) == null) continue;
            methods.put(implementation, method);
            return unwrapped;
        }
        methods.put(implementation, IGNORE);
        return null;
    }

    private <T> T unwrapInternal(Class<T> target, T conn, Class<?> wrapper, Method accessMethod) {
        if (accessMethod == null) {
            LOGGER.finest("Using " + wrapper.getName() + " does not have accessMethod to unwrap " + target.getSimpleName());
            return null;
        }
        try {
            Object result = accessMethod.invoke(conn, (Object[])null);
            if (result == null) {
                LOGGER.finest("Using " + wrapper.getName() + "." + accessMethod.getName() + "() to unwrap " + target.getSimpleName() + " produced a null");
                return null;
            }
            if (result == conn) {
                LOGGER.finest("Using " + wrapper.getName() + "." + accessMethod.getName() + "() to unwrap did not result in native " + target.getSimpleName() + ": " + result.getClass().getSimpleName());
                return null;
            }
            if (!target.isInstance(result)) {
                LOGGER.finest("Using " + wrapper.getName() + "." + accessMethod.getName() + "() to unwrap did not result in native " + target.getSimpleName() + ": " + result.getClass().getSimpleName());
                return null;
            }
            return target.cast(result);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOGGER.log(Level.FINEST, "Using " + wrapper.getName() + "." + accessMethod.getName() + "() to unwrap " + target.getSimpleName() + " failed: " + String.valueOf(e));
            return null;
        }
    }

    static {
        try {
            IGNORE = GenericUnWrapper.class.getMethod("ignore", new Class[0]);
        }
        catch (Exception inconsistent) {
            throw new IllegalStateException("Expected static GenericUnWrapper ignore() method", inconsistent);
        }
        CONNECTION_METHODS = new ConcurrentHashMap();
        GenericUnWrapper.methodSearch("JBoss EAP 6.0", CONNECTION_METHODS, "org.jboss.jca.adapters.jdbc.jdk6.WrappedConnectionJDK6", "getUnderlyingConnection");
        GenericUnWrapper.methodSearch("JBoss JCA", CONNECTION_METHODS, "org.jboss.jca.adapters.jdbc.WrappedConnection", "getUnderlyingConnection");
        GenericUnWrapper.methodSearch("JBoss Resource Adapter", CONNECTION_METHODS, "org.jboss.resource.adapter.jdbc.WrappedConnection", "getUnderlyingConnection");
        STATEMENT_METHODS = new ConcurrentHashMap();
        GenericUnWrapper.methodSearch("JBoss Resource Adapter", STATEMENT_METHODS, "org.jboss.resource.adapter.jdbc.WrappedCallableStatement", "getUnderlyingStatement");
    }
}

