/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.util;

import java.awt.RenderingHints;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.util.factory.Hints;
import org.geotools.xml.impl.DatatypeConverterImpl;

public final class TemporalUtils {
    private TemporalUtils() {
    }

    public static String printDate(Date date) {
        if (date == null) {
            return "null";
        }
        Calendar calendar = TemporalUtils.toCalendar(date);
        if (date instanceof java.sql.Date) {
            return DatatypeConverterImpl.getInstance().printDate(calendar);
        }
        return DatatypeConverterImpl.getInstance().printDateTime(calendar);
    }

    private static Calendar toCalendar(Date date) {
        Object hint = Hints.getSystemDefault((RenderingHints.Key)Hints.LOCAL_DATE_TIME_HANDLING);
        Calendar calendar = Boolean.TRUE.equals(hint) ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        return calendar;
    }

    public static boolean isDateTimeFormatEnabled() {
        Object hint = Hints.getSystemDefault((RenderingHints.Key)Hints.DATE_TIME_FORMAT_HANDLING);
        return !Boolean.FALSE.equals(hint);
    }

    public static String serializeDateTime(Date date, String dateFormatPattern) {
        try {
            Object hint = Hints.getSystemDefault((RenderingHints.Key)Hints.LOCAL_DATE_TIME_HANDLING);
            Calendar cal = TemporalUtils.toCalendar(date);
            if (date instanceof java.sql.Date) {
                SimpleDateFormat formatter = new SimpleDateFormat(dateFormatPattern);
                return formatter.format(date);
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormatPattern);
            ZonedDateTime zonedDateTime = Boolean.TRUE.equals(hint) ? cal.toInstant().atZone(ZoneId.systemDefault()) : cal.toInstant().atZone(TimeZone.getTimeZone("UTC").toZoneId());
            return zonedDateTime.format(formatter);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error formatting date" + String.valueOf(ex));
        }
    }
}

