/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.geotools.util.logging.Logging;

public class BufferedRequestStream
extends ServletInputStream {
    InputStream myInputStream;

    public BufferedRequestStream(byte[] buff) throws IOException {
        this.myInputStream = new ByteArrayInputStream(buff);
        this.myInputStream.mark(16);
        this.myInputStream.read();
        this.myInputStream.reset();
    }

    public BufferedRequestStream(InputStream inputStream) throws IOException {
        this.myInputStream = inputStream;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        int read;
        int index;
        if (this.myInputStream == null) {
            throw new IOException("Stream closed");
        }
        int end = off + len;
        for (index = off; index < end && (read = this.myInputStream.read()) != -1; ++index) {
            b[index] = (byte)read;
            if ((char)read != '\n') continue;
            break;
        }
        return index - off;
    }

    public boolean isFinished() {
        try {
            return this.available() < 1;
        }
        catch (IOException e) {
            Logger LOGGER = Logging.getLogger(BufferedRequestStream.class);
            LOGGER.finer("Stream is closed");
            return true;
        }
    }

    public boolean isReady() {
        return true;
    }

    public void setReadListener(ReadListener readListener) {
        throw new UnsupportedOperationException("Not supported with BufferedInputStream");
    }

    public int read() throws IOException {
        if (this.myInputStream == null) {
            throw new IOException("Stream closed");
        }
        return this.myInputStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.myInputStream == null) {
            throw new IOException("Stream closed");
        }
        return this.myInputStream.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        if (this.myInputStream == null) {
            throw new IOException("Stream closed");
        }
        return this.myInputStream.skip(n);
    }

    public int available() throws IOException {
        if (this.myInputStream == null) {
            throw new IOException("Stream closed");
        }
        return this.myInputStream.available();
    }

    public void close() throws IOException {
        if (this.myInputStream != null) {
            try {
                this.myInputStream.close();
            }
            finally {
                this.myInputStream = null;
            }
        } else {
            Logger LOGGER = Logging.getLogger(BufferedRequestStream.class);
            LOGGER.finer("Stream already closed");
        }
    }

    public synchronized void mark(int readlimit) {
        if (this.myInputStream != null) {
            this.myInputStream.mark(readlimit);
        }
    }

    public synchronized void reset() throws IOException {
        if (this.myInputStream == null) {
            throw new IOException("Stream closed");
        }
        this.myInputStream.reset();
    }

    public boolean markSupported() {
        if (this.myInputStream == null) {
            return false;
        }
        return this.myInputStream.markSupported();
    }
}

