/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.geoserver.filters.BufferedRequestStream;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

public class BufferedRequestWrapper
extends HttpServletRequestWrapper {
    protected HttpServletRequest myWrappedRequest;
    protected byte[] myBuffer;
    protected String charset;
    protected ServletInputStream myStream = null;
    protected BufferedReader myReader = null;
    protected Map<String, List<String>> myParameterMap;
    private static final Logger LOGGER = Logging.getLogger(BufferedRequestWrapper.class);

    public BufferedRequestWrapper(HttpServletRequest req, String charset, byte[] buff) {
        super(req);
        this.myWrappedRequest = req;
        this.myBuffer = buff;
        this.charset = charset;
    }

    public BufferedRequestWrapper(HttpServletRequest req, String charset, BufferedInputStream bufferedInputStream) throws IOException {
        super(req);
        this.myWrappedRequest = req;
        this.myReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, charset));
        this.charset = charset;
        this.myStream = new BufferedRequestStream(bufferedInputStream);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.myStream == null) {
            if (this.myReader == null) {
                this.myStream = new BufferedRequestStream(this.myBuffer);
            } else if (!this.myReader.ready()) {
                throw new IOException("Reader is not ready!!");
            }
        }
        return this.myStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.myReader == null) {
            if (this.myStream == null) {
                this.myReader = new BufferedReader(new InputStreamReader((InputStream)((Object)new BufferedRequestStream(this.myBuffer)), this.charset));
            } else {
                throw new IOException("Requesting a reader after a stream is already in use!!");
            }
        }
        return this.myReader;
    }

    public String getParameter(String name) {
        this.parseParameters();
        List<String> allValues = this.myParameterMap.get(name);
        if (allValues == null || allValues.isEmpty()) {
            return null;
        }
        return allValues.get(0);
    }

    public Map<String, String[]> getParameterMap() {
        this.parseParameters();
        TreeMap<String, String[]> toArrays = new TreeMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : this.myParameterMap.entrySet()) {
            String[] value = entry.getValue().toArray(new String[0]);
            toArrays.put(entry.getKey(), value);
        }
        return Collections.unmodifiableMap(toArrays);
    }

    public Enumeration<String> getParameterNames() {
        this.parseParameters();
        return new IteratorAsEnumeration<String>(this.myParameterMap.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        this.parseParameters();
        List<String> allValues = this.myParameterMap.get(name);
        if (allValues == null || allValues.isEmpty()) {
            return null;
        }
        return allValues.toArray(new String[0]);
    }

    protected void parseParameters() {
        if (this.myParameterMap != null) {
            return;
        }
        String contentType = this.myWrappedRequest.getContentType();
        if (this.myWrappedRequest.getMethod().equals("POST") && contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
            this.parseFormBody();
        } else {
            Map superParameters = super.getParameterMap();
            this.myParameterMap = new HashMap<String, List<String>>();
            for (String key : superParameters.keySet()) {
                Object value = superParameters.get(key);
                if (value instanceof String[]) {
                    String[] strings = (String[])value;
                    this.myParameterMap.put(key, Arrays.asList(strings));
                    continue;
                }
                if (value instanceof List) continue;
                List converted = (List)Converters.convert(value, List.class);
                this.myParameterMap.put(key, converted);
            }
        }
    }

    protected void parseFormBody() {
        String[] pairs;
        this.myParameterMap = new TreeMap<String, List<String>>();
        try {
            pairs = this.myBuffer != null ? new String(this.myBuffer, this.charset).split("\\&") : this.myReader.lines().collect(Collectors.joining()).split("\\&");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        for (String s : pairs) {
            this.parsePair(s);
        }
        if (this.myWrappedRequest.getQueryString() != null) {
            for (String pair : pairs = this.myWrappedRequest.getQueryString().split("\\&")) {
                this.parsePair(pair);
            }
        }
    }

    protected void parsePair(String pair) {
        String[] split = pair.split("=", 2);
        try {
            String value;
            String key = URLDecoder.decode(split[0], "UTF-8");
            String string = value = split.length > 1 ? URLDecoder.decode(split[1], "UTF-8") : "";
            if (!this.myParameterMap.containsKey(key)) {
                this.myParameterMap.put(key, new ArrayList());
            }
            this.myParameterMap.get(key).add(value);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.severe("Failed to decode form values in LoggingFilter");
        }
    }

    private static class IteratorAsEnumeration<T>
    implements Enumeration<T> {
        Iterator<T> it;

        public IteratorAsEnumeration(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        @Override
        public T nextElement() {
            return this.it.next();
        }
    }
}

