/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.filters.GZIPResponseWrapper;

public class GZIPFilter
implements Filter {
    private Set<Pattern> myCompressedTypes;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String ae = request.getHeader("accept-encoding");
            if (ae != null && ae.indexOf("gzip") != -1) {
                GZIPResponseWrapper wrappedResponse = new GZIPResponseWrapper(response, this.myCompressedTypes, request.getRequestURL().toString());
                chain.doFilter(req, (ServletResponse)wrappedResponse);
                wrappedResponse.finishResponse();
                return;
            }
        }
        chain.doFilter(req, res);
    }

    public void init(FilterConfig filterConfig) {
        try {
            String compressedTypes = filterConfig.getInitParameter("compressed-types");
            String[] typeNames = compressedTypes == null ? new String[]{} : compressedTypes.split(",");
            this.myCompressedTypes = new HashSet<Pattern>();
            for (String typeName : typeNames) {
                this.myCompressedTypes.add(Pattern.compile(typeName));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while setting up GZIPFilter; " + String.valueOf(e));
        }
    }

    public void destroy() {
    }
}

