/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.filters.GeoServerFilter;

public class HTTPMethodFilter
implements GeoServerFilter {
    private static final List<String> HTTP_METHOD_OPTIONS = List.of("GET", "POST", "PUT", "DELETE", "HEAD", "PATCH", "OPTIONS");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                if (!HTTP_METHOD_OPTIONS.contains(httpRequest.getMethod())) {
                    httpResponse.sendError(405);
                    return;
                }
                chain.doFilter(request, response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

