/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.csp.CSPHeaderDAO;
import org.geotools.util.logging.Logging;

public class SecurityHeadersFilter
implements Filter {
    private static final Logger LOGGER = Logging.getLogger(SecurityHeadersFilter.class);
    private static final String DEFAULT_HSTS_POLICY = "max-age=31536000 ; includeSubDomains";
    private static final String DEFAULT_FRAME_POLICY = "SAMEORIGIN";
    private static final String DEFAULT_XXSS_POLICY = "0";
    public static final String GEOSERVER_HSTS_SHOULD_SET_POLICY = "geoserver.hsts.shouldSetPolicy";
    public static final String GEOSERVER_HSTS_POLICY = "geoserver.hsts.policy";
    public static final String GEOSERVER_XFRAME_SHOULD_SET_POLICY = "geoserver.xframe.shouldSetPolicy";
    public static final String GEOSERVER_XFRAME_POLICY = "geoserver.xframe.policy";
    public static final String GEOSERVER_XCONTENT_TYPE_SHOULD_SET_POLICY = "geoserver.xContentType.shouldSetPolicy";
    public static final String GEOSERVER_XXSS_PROTECTION_SHOULD_SET_POLICY = "geoserver.xXssProtection.shouldSetPolicy";
    public static final String GEOSERVER_XXSS_PROTECTION_POLICY = "geoserver.xXssProtection.policy";
    private volatile Map<String, Object> cache = null;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Map<String, Object> map = this.getCache();
        if (request.isSecure() && ((Boolean)map.get(GEOSERVER_HSTS_SHOULD_SET_POLICY)).booleanValue()) {
            httpResponse.setHeader("Strict-Transport-Security", (String)map.get(GEOSERVER_HSTS_POLICY));
        }
        if (((Boolean)map.get(GEOSERVER_XCONTENT_TYPE_SHOULD_SET_POLICY)).booleanValue()) {
            httpResponse.setHeader("X-Content-Type-Options", "nosniff");
        }
        if (((Boolean)map.get(GEOSERVER_XFRAME_SHOULD_SET_POLICY)).booleanValue()) {
            httpResponse.setHeader("X-Frame-Options", (String)map.get(GEOSERVER_XFRAME_POLICY));
        }
        if (((Boolean)map.get(GEOSERVER_XXSS_PROTECTION_SHOULD_SET_POLICY)).booleanValue()) {
            httpResponse.setHeader("X-XSS-Protection", (String)map.get(GEOSERVER_XXSS_PROTECTION_POLICY));
        }
        try {
            response = ((CSPHeaderDAO)((Object)GeoServerExtensions.bean(CSPHeaderDAO.class))).setContentSecurityPolicy((HttpServletRequest)request, httpResponse);
            chain.doFilter(request, response);
        }
        finally {
            CSPHeaderDAO.removeProxyPolicy();
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getCache() {
        if (this.cache == null) {
            SecurityHeadersFilter securityHeadersFilter = this;
            synchronized (securityHeadersFilter) {
                if (this.cache == null) {
                    this.cache = SecurityHeadersFilter.initializeCache();
                }
            }
        }
        return this.cache;
    }

    private static boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = SecurityHeadersFilter.getStringProperty(key, null);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    private static String getStringProperty(String key, String defaultValue) {
        String value = GeoServerExtensions.getProperty((String)key);
        return StringUtils.isBlank((CharSequence)value) ? defaultValue : value.trim();
    }

    private static Map<String, Object> initializeCache() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(GEOSERVER_HSTS_SHOULD_SET_POLICY, SecurityHeadersFilter.getBooleanProperty(GEOSERVER_HSTS_SHOULD_SET_POLICY, false));
        map.put(GEOSERVER_HSTS_POLICY, SecurityHeadersFilter.getStringProperty(GEOSERVER_HSTS_POLICY, DEFAULT_HSTS_POLICY));
        map.put(GEOSERVER_XCONTENT_TYPE_SHOULD_SET_POLICY, SecurityHeadersFilter.getBooleanProperty(GEOSERVER_XCONTENT_TYPE_SHOULD_SET_POLICY, true));
        map.put(GEOSERVER_XFRAME_SHOULD_SET_POLICY, SecurityHeadersFilter.getBooleanProperty(GEOSERVER_XFRAME_SHOULD_SET_POLICY, true));
        map.put(GEOSERVER_XFRAME_POLICY, SecurityHeadersFilter.getStringProperty(GEOSERVER_XFRAME_POLICY, DEFAULT_FRAME_POLICY));
        map.put(GEOSERVER_XXSS_PROTECTION_SHOULD_SET_POLICY, SecurityHeadersFilter.getBooleanProperty(GEOSERVER_XXSS_PROTECTION_SHOULD_SET_POLICY, false));
        map.put(GEOSERVER_XXSS_PROTECTION_POLICY, SecurityHeadersFilter.getStringProperty(GEOSERVER_XXSS_PROTECTION_POLICY, DEFAULT_XXSS_POLICY));
        LOGGER.fine(() -> "Security HTTP response header settings: \n " + map.entrySet().stream().map(e -> (String)e.getKey() + " = " + String.valueOf(e.getValue())).collect(Collectors.joining("\n ")));
        return Collections.unmodifiableMap(map);
    }
}

