/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.function;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.VolatileFunction;
import org.geotools.api.parameter.Parameter;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.Converters;

public class IsInstanceOf
implements VolatileFunction,
Function {
    public static FunctionName NAME = new FunctionNameImpl("isInstanceOf", Boolean.class, new Parameter[]{FunctionNameImpl.parameter((String)"class", Class.class)});
    private List<Expression> parameters;
    private Literal fallback;

    public IsInstanceOf() {
        this.parameters = new ArrayList<Expression>();
        this.fallback = null;
    }

    protected IsInstanceOf(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
        if (parameters == null) {
            throw new NullPointerException("parameter required");
        }
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("isInstanceOf(class) requires one parameter only");
        }
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Boolean.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Expression clazzExpression = this.parameters.get(0);
        Class clazz = (Class)clazzExpression.evaluate(object, Class.class);
        boolean result = false;
        if (clazz != null) {
            result = clazz == Object.class ? true : clazz.isAssignableFrom(object.getClass());
        }
        return (T)Converters.convert((Object)result, context);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public String getName() {
        return NAME.getName();
    }

    public FunctionName getFunctionName() {
        return NAME;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    public String toString() {
        List<Expression> params = this.getParameters();
        if (params == null || params.isEmpty()) {
            return "IsInstanceOf([INVALID])";
        }
        return "IsInstanceOf(" + String.valueOf(params.get(0)) + ")";
    }
}

