/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.jai;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.imagen.media.cache.ConcurrentTileCacheMultiMap;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;

public class GeoServerTileCache
extends ConcurrentTileCacheMultiMap
implements DispatcherCallback {
    static final Logger LOGGER = Logging.getLogger(GeoServerTileCache.class);
    final Cache<Request, Set<RenderedImage>> images = CacheBuilder.newBuilder().weakKeys().build();

    public void add(RenderedImage owner, int tileX, int tileY, Raster data) {
        this.recordImage(owner);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding tile (%d,%d) for image %s[%d]".formatted(tileX, tileY, owner.getClass(), owner.hashCode()));
        }
        super.add(owner, tileX, tileY, data);
    }

    public void add(RenderedImage owner, int tileX, int tileY, Raster data, Object tileCacheMetric) {
        this.recordImage(owner);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding tile (%d,%d) for image %s[%d]".formatted(tileX, tileY, owner.getClass(), owner.hashCode()));
        }
        super.add(owner, tileX, tileY, data, tileCacheMetric);
    }

    public void addTiles(RenderedImage owner, Point[] tileIndices, Raster[] tiles, Object tileCacheMetric) {
        this.recordImage(owner);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding tiles (%s) for image %s[%d]".formatted(Arrays.toString(tileIndices), owner.getClass(), owner.hashCode()));
        }
        super.addTiles(owner, tileIndices, tiles, tileCacheMetric);
    }

    public Raster getTile(RenderedImage owner, int tileX, int tileY) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting tile (%d,%d) for image %s[%d]".formatted(tileX, tileY, owner.getClass(), owner.hashCode()));
        }
        return super.getTile(owner, tileX, tileY);
    }

    public Raster[] getTiles(RenderedImage owner) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting all tiles for image %s[%d]".formatted(owner.getClass(), owner.hashCode()));
        }
        return super.getTiles(owner);
    }

    public Raster[] getTiles(RenderedImage owner, Point[] tileIndices) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting tiles (%s) for image %s[%d]".formatted(Arrays.toString(tileIndices), owner.getClass(), owner.hashCode()));
        }
        return super.getTiles(owner, tileIndices);
    }

    public void remove(RenderedImage owner, int tileX, int tileY) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Removing tile (%d,%d) for image %s[%d]".formatted(tileX, tileY, owner.getClass(), owner.hashCode()));
        }
        super.remove(owner, tileX, tileY);
    }

    private void recordImage(RenderedImage owner) {
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request == null) {
            return;
        }
        Set images = this.images.asMap().computeIfAbsent(request, r -> ConcurrentHashMap.newKeySet());
        images.add(owner);
    }

    public void removeTiles(RenderedImage owner) {
        if (LOGGER.isLoggable(Level.FINE) && super.getTiles(owner) != null) {
            LOGGER.fine("Removing all tiles for image %s[%d]".formatted(owner.getClass(), owner.hashCode()));
        }
        super.removeTiles(owner);
    }

    public Request init(Request request) {
        return request;
    }

    public Service serviceDispatched(Request request, Service service) throws ServiceException {
        return service;
    }

    public Operation operationDispatched(Request request, Operation operation) {
        return operation;
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        return result;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        return response;
    }

    public void finished(Request request) {
        Set images = (Set)this.images.getIfPresent((Object)request);
        if (images != null) {
            for (RenderedImage image : images) {
                this.removeTiles(image);
            }
        }
        this.images.invalidate((Object)request);
    }
}

