/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.jai;

import java.util.List;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.TileCache;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.ImageProcessingInfo;
import org.geoserver.jai.ConcurrentTileFactory;
import org.geoserver.jai.GeoServerTileCache;
import org.geoserver.jai.PassThroughTileFactory;

public class ImageNInitializer
implements GeoServerInitializer {
    private final GeoServerTileCache tileCache;

    public ImageNInitializer(GeoServerTileCache tileCache) {
        this.tileCache = tileCache;
    }

    @Override
    public void initialize(GeoServer geoServer) throws Exception {
        this.initJAI(geoServer.getGlobal().getImageProcessing());
        geoServer.addListener(new ConfigurationListenerAdapter(){

            @Override
            public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                if (propertyNames.contains("jAI")) {
                    ImageNInitializer.this.initJAI(global.getImageProcessing());
                }
            }
        });
    }

    void initJAI(ImageProcessingInfo imageProcessing) {
        ImageN imageN = ImageN.getDefaultInstance();
        imageProcessing.setImageProcessing(imageN);
        imageN.setRenderingHint(ImageN.KEY_CACHED_TILE_RECYCLING_ENABLED, (Object)imageProcessing.isRecycling());
        TileCache oldTileCache = imageProcessing.getTileCache();
        if (oldTileCache != this.tileCache) {
            imageProcessing.setTileCache((TileCache)this.tileCache);
            oldTileCache.flush();
        }
        if (imageProcessing.isRecycling() && !(imageN.getRenderingHint(ImageN.KEY_TILE_FACTORY) instanceof ConcurrentTileFactory)) {
            ConcurrentTileFactory recyclingFactory = new ConcurrentTileFactory();
            imageN.setRenderingHint(ImageN.KEY_TILE_FACTORY, (Object)recyclingFactory);
            imageN.setRenderingHint(ImageN.KEY_TILE_RECYCLER, (Object)recyclingFactory);
        } else if (!imageProcessing.isRecycling()) {
            PassThroughTileFactory passThroughFactory = new PassThroughTileFactory();
            imageN.setRenderingHint(ImageN.KEY_TILE_FACTORY, (Object)passThroughFactory);
            imageN.setRenderingHint(ImageN.KEY_TILE_RECYCLER, (Object)passThroughFactory);
        }
        TileCache jaiCache = imageN.getTileCache();
        imageProcessing.setTileCache(jaiCache);
        long jaiMemory = (long)(imageProcessing.getMemoryCapacity() * (double)Runtime.getRuntime().maxMemory());
        jaiCache.setMemoryCapacity(jaiMemory);
        jaiCache.setMemoryThreshold((float)imageProcessing.getMemoryThreshold());
        imageN.getTileScheduler().setParallelism(imageProcessing.getTileThreads());
        imageN.getTileScheduler().setPrefetchParallelism(imageProcessing.getTileThreads());
        imageN.getTileScheduler().setPriority(imageProcessing.getTilePriority());
        imageN.getTileScheduler().setPrefetchPriority(imageProcessing.getTilePriority());
    }
}

