/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.LocalPublished;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AbstractCatalogFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.expression.InternalVolatileFunction;
import org.geotools.util.decorate.Wrapper;

public class LocalWorkspaceCatalogFilter
extends AbstractCatalogFilter {
    Catalog catalog;
    static Boolean groupInherit = null;

    public LocalWorkspaceCatalogFilter(Catalog catalog) {
        Catalog unwrapped;
        Wrapper w;
        while (catalog instanceof Wrapper && (w = (Wrapper)catalog).isWrapperFor(Catalog.class) && (unwrapped = (Catalog)((Wrapper)catalog).unwrap(Catalog.class)) != catalog && unwrapped != null) {
            catalog = unwrapped;
        }
        this.catalog = catalog;
    }

    @Override
    public boolean hideLayer(LayerInfo layer) {
        PublishedInfo local = LocalPublished.get();
        if (local == null) {
            return false;
        }
        if (local instanceof LayerInfo) {
            return !local.equals(layer);
        }
        if (local instanceof LayerGroupInfo) {
            LayerGroupInfo lg = (LayerGroupInfo)local;
            Request request = (Request)Dispatcher.REQUEST.get();
            if (request != null && "WMS".equalsIgnoreCase(request.getService()) && "GetCapabilities".equals(request.getRequest()) && lg.getMode() == LayerGroupInfo.Mode.SINGLE) {
                return true;
            }
            return !new LayerGroupHelper(lg).allLayers().contains(layer);
        }
        throw new RuntimeException("Unknown PublishedInfo of type " + String.valueOf(local.getClass()));
    }

    @Override
    public boolean hideResource(ResourceInfo resource) {
        if (LocalPublished.get() != null) {
            for (LayerInfo l : resource.getCatalog().getLayers(resource)) {
                if (!this.hideLayer(l)) continue;
                return true;
            }
        }
        return this.hideWorkspace(resource.getStore().getWorkspace());
    }

    @Override
    public boolean hideWorkspace(WorkspaceInfo workspace) {
        return LocalWorkspace.get() != null && !LocalWorkspace.get().equals(workspace);
    }

    @Override
    public boolean hideStyle(StyleInfo style) {
        if (style.getWorkspace() == null) {
            return LocalWorkspace.get() != null && this.catalog.getStyleByName(LocalWorkspace.get(), style.getName()) != null;
        }
        return this.hideWorkspace(style.getWorkspace());
    }

    public static boolean workspaceLayerGroupInherit() {
        if (groupInherit == null) {
            String value = GeoServerExtensions.getProperty((String)"GEOSERVER_GLOBAL_LAYER_GROUP_INHERIT");
            groupInherit = value != null ? Boolean.valueOf(Boolean.parseBoolean(value)) : Boolean.valueOf(true);
        }
        return groupInherit;
    }

    @Override
    public boolean hideLayerGroup(LayerGroupInfo layerGroup) {
        PublishedInfo local = LocalPublished.get();
        if (local != null) {
            if (local instanceof LayerGroupInfo) {
                LayerGroupInfo lg = (LayerGroupInfo)local;
                Request request = (Request)Dispatcher.REQUEST.get();
                if (request != null && "WMS".equalsIgnoreCase(request.getService()) && "GetCapabilities".equals(request.getRequest()) && lg.getMode() == LayerGroupInfo.Mode.SINGLE) {
                    return !lg.equals(layerGroup);
                }
                if (!lg.equals(layerGroup) && !new LayerGroupHelper(lg).allGroups().contains(layerGroup)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (layerGroup.getWorkspace() == null) {
            if (LocalWorkspaceCatalogFilter.workspaceLayerGroupInherit()) {
                return LocalWorkspace.get() != null && this.catalog.getLayerGroupByName(LocalWorkspace.get(), layerGroup.getName()) != null;
            }
            return LocalWorkspace.get() != null;
        }
        return this.hideWorkspace(layerGroup.getWorkspace());
    }

    protected boolean subLayersHidden(LayerGroupInfo layerGroup) {
        boolean anySublayersVisible = false;
        for (PublishedInfo subLayer : layerGroup.getLayers()) {
            LayerGroupInfo info;
            if (subLayer instanceof LayerInfo) {
                LayerInfo info1 = (LayerInfo)subLayer;
                if (this.hideLayer(info1)) continue;
                anySublayersVisible = true;
                break;
            }
            if (!(subLayer instanceof LayerGroupInfo) || this.hideLayerGroup(info = (LayerGroupInfo)subLayer)) continue;
            anySublayersVisible = true;
            break;
        }
        return !anySublayersVisible;
    }

    private Filter inWorkspace() {
        WorkspaceInfo localWS = LocalWorkspace.get();
        if (localWS == null) {
            return Predicates.acceptAll();
        }
        return Predicates.equal("workspace.id", localWS.getId());
    }

    private Filter standardFilter(Class<? extends CatalogInfo> clazz) {
        Filter forGlobal = LocalWorkspace.get() != null ? super.getSecurityFilter(clazz) : Predicates.acceptAll();
        return Predicates.or(Predicates.and(Predicates.isNull("workspace.id"), forGlobal), Predicates.and((Filter)Predicates.factory.not(Predicates.isNull("workspace.id")), this.inWorkspace()));
    }

    @Override
    public Filter getSecurityFilter(Class<? extends CatalogInfo> clazz) {
        WorkspaceInfo localWS = LocalWorkspace.get();
        PublishedInfo localPublished = LocalPublished.get();
        if (localWS == null && localPublished == null) {
            return Predicates.acceptAll();
        }
        if (ResourceInfo.class.isAssignableFrom(clazz)) {
            if (localPublished != null) {
                return super.getSecurityFilter(clazz);
            }
            Filter localLayerFilter = Predicates.acceptAll();
            return Predicates.or(localLayerFilter, this.inWorkspace());
        }
        if (WorkspaceInfo.class.isAssignableFrom(clazz)) {
            if (localWS == null) {
                return Predicates.acceptAll();
            }
            return Predicates.equal("id", localWS.getId());
        }
        if (LayerGroupInfo.class.isAssignableFrom(clazz)) {
            Filter filter = this.standardFilter(clazz);
            if (localPublished != null) {
                if (localPublished instanceof LayerInfo) {
                    InternalVolatileFunction subLayersHidden = new InternalVolatileFunction(){

                        public Boolean evaluate(Object object) {
                            return !LocalWorkspaceCatalogFilter.this.subLayersHidden((LayerGroupInfo)object);
                        }
                    };
                    FilterFactory factory = Predicates.factory;
                    filter = Predicates.and(filter, (Filter)factory.equals((Expression)factory.literal((Object)Boolean.TRUE), (Expression)subLayersHidden));
                    Predicates.and(filter, Predicates.equal("id", localPublished.getId()));
                } else if (localPublished instanceof LayerGroupInfo) {
                    LayerGroupInfo lg = (LayerGroupInfo)localPublished;
                    List<LayerGroupInfo> groups = new LayerGroupHelper(lg).allGroups();
                    ArrayList<Filter> groupIdFilters = new ArrayList<Filter>();
                    for (LayerGroupInfo group : groups) {
                        groupIdFilters.add(Predicates.equal("id", group.getId()));
                    }
                    return Predicates.or(groupIdFilters);
                }
            }
            return filter;
        }
        if (StyleInfo.class.isAssignableFrom(clazz)) {
            return this.standardFilter(clazz);
        }
        if (LayerInfo.class.isAssignableFrom(clazz)) {
            if (localPublished == null) {
                return Predicates.acceptAll();
            }
            if (localPublished instanceof LayerInfo) {
                return Predicates.equal("id", localPublished.getId());
            }
            if (localPublished instanceof LayerGroupInfo) {
                LayerGroupInfo lg = (LayerGroupInfo)localPublished;
                Request request = (Request)Dispatcher.REQUEST.get();
                if (request != null && "WMS".equalsIgnoreCase(request.getService()) && "GetCapabilities".equals(request.getRequest()) && lg.getMode() == LayerGroupInfo.Mode.SINGLE) {
                    return Predicates.acceptNone();
                }
                List<LayerInfo> layers = new LayerGroupHelper(lg).allLayers();
                ArrayList<Filter> layersIdFilters = new ArrayList<Filter>();
                for (LayerInfo layer : layers) {
                    layersIdFilters.add(Predicates.equal("id", layer.getId()));
                }
                return Predicates.or(layersIdFilters);
            }
            throw new RuntimeException("Unexpected local published reference of type " + String.valueOf(localPublished.getClass()));
        }
        if (NamespaceInfo.class.isAssignableFrom(clazz)) {
            return super.getSecurityFilter(clazz);
        }
        return super.getSecurityFilter(clazz);
    }
}

