/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.HTTPHeadersCollector;
import org.geoserver.ows.QuickTemplate;
import org.geoserver.ows.URLMangler;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;

public class ProxifyingURLMangler
implements URLMangler {
    GeoServer geoServer;
    public static String TEMPLATE_SEPARATOR = " ";
    public static String TEMPLATE_PREFIX = "${";
    public static String TEMPLATE_POSTFIX = "}";
    public static Map<String, Pattern> FORWARDED_PATTERNS = new HashMap<String, Pattern>();

    public ProxifyingURLMangler(GeoServer geoServer) {
        Arrays.asList(ForwardedComponents.values()).forEach(comp -> FORWARDED_PATTERNS.put(comp.asString(), Pattern.compile("(.*)%s=([^;^ ]+)(.*)".formatted(comp.asString()))));
        this.geoServer = geoServer;
    }

    public void mangleURL(StringBuilder baseURL, StringBuilder path, Map<String, String> kvp, URLMangler.URLType type) {
        String proxyBase = GeoServerExtensions.getProperty((String)"PROXY_BASE_URL") != null ? GeoServerExtensions.getProperty((String)"PROXY_BASE_URL") : this.geoServer.getSettings().getProxyBaseUrl();
        proxyBase = this.resolveParametrization(proxyBase);
        boolean doMangleHeaders = this.resolveDoMangleHeaders();
        if (proxyBase != null && doMangleHeaders) {
            this.mangleURLHeaders(baseURL, proxyBase);
        } else {
            this.mangleURLFixedURL(baseURL, proxyBase);
        }
    }

    private boolean resolveDoMangleHeaders() {
        Boolean resultFlag;
        if (this.isUseHeadersSystemPropertyEnabled()) {
            return true;
        }
        Boolean wsAwareFlag = this.geoServer.getSettings().isUseHeadersProxyURL();
        Boolean bl = resultFlag = wsAwareFlag != null ? wsAwareFlag : this.geoServer.getGlobal().getSettings().isUseHeadersProxyURL();
        if (resultFlag != null) {
            return resultFlag;
        }
        return false;
    }

    private boolean isUseHeadersSystemPropertyEnabled() {
        String useHeadersProxyURL = GeoServerExtensions.getProperty((String)"PROXY_BASE_URL_HEADERS");
        return useHeadersProxyURL != null && "true".equalsIgnoreCase(useHeadersProxyURL.trim());
    }

    private String resolveParametrization(String proxyBase) {
        if (GeoServerEnvironment.allowEnvParametrization() && StringUtils.isNotBlank((CharSequence)proxyBase)) {
            GeoServerEnvironment gsEnvironment = (GeoServerEnvironment)GeoServerExtensions.bean(GeoServerEnvironment.class);
            proxyBase = (String)gsEnvironment.resolveValue((Object)proxyBase);
        }
        return proxyBase;
    }

    private StringBuilder mangleURLFixedURL(StringBuilder baseURL, String proxyBase) {
        if (proxyBase != null && !proxyBase.trim().isEmpty()) {
            baseURL.setLength(0);
            baseURL.append(proxyBase);
        }
        return baseURL;
    }

    private StringBuilder mangleURLHeaders(StringBuilder baseURL, String proxyBase) {
        if (!proxyBase.contains(TEMPLATE_PREFIX)) {
            return this.mangleURLFixedURL(baseURL, proxyBase);
        }
        Map<String, String> headers = this.compileHeadersMap();
        for (String template : Arrays.asList(proxyBase.split(TEMPLATE_SEPARATOR))) {
            String candidate = QuickTemplate.replaceVariables(template, headers);
            if (candidate.contains(TEMPLATE_PREFIX)) continue;
            baseURL.setLength(0);
            baseURL.append(candidate);
            break;
        }
        return baseURL;
    }

    private Map<String, String> compileHeadersMap() {
        HashMap<String, String> headers = new HashMap<String, String>();
        Arrays.asList(Headers.values()).forEach(h -> this.collectHeader(headers, h.asString()));
        return headers;
    }

    private void collectHeader(Map<String, String> headers, String headerName) {
        String headerValue = HTTPHeadersCollector.getHeader(headerName);
        if (headerValue != null) {
            if (headerName.equals(Headers.FORWARDED.asString())) {
                this.collectForwardedHeaders(headers, headerValue);
            } else {
                headers.put(this.toTemplate(headerName), headerValue);
            }
        }
    }

    private void collectForwardedHeaders(Map<String, String> headers, String headerValue) {
        FORWARDED_PATTERNS.forEach((comp, pattern) -> {
            Matcher m = pattern.matcher(headerValue);
            if (m.matches()) {
                String key = this.toTemplate(Headers.FORWARDED.asString() + "." + comp);
                headers.put(key, m.group(2));
            }
        });
    }

    private String toTemplate(String header) {
        return "%s%s%s".formatted(TEMPLATE_PREFIX, header, TEMPLATE_POSTFIX);
    }

    public static enum ForwardedComponents {
        FOR("for"),
        BY("by"),
        PROTO("proto"),
        HOST("host"),
        PATH("path");

        private String comp;

        private ForwardedComponents(String c) {
            this.comp = c;
        }

        public String asString() {
            return this.comp;
        }
    }

    public static enum Headers {
        FORWARDED("Forwarded"),
        FORWARDED_PROTO("X-Forwarded-Proto"),
        FORWARDED_HOST("X-Forwarded-Host"),
        FORWARDED_PATH("X-Forwarded-Path"),
        FORWARDED_FOR("X-Forwarded-For"),
        HOST("Host");

        private String header;

        private Headers(String h) {
            this.header = h;
        }

        public String asString() {
            return this.header;
        }
    }
}

