/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.util.regex.Pattern;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.platform.ServiceException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml2.SrsSyntax;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;

public class ClipGeometryParser {
    private static final Pattern SRID_REGEX = Pattern.compile("SRID=[0-9].*");
    private static final WKTReader2 reader = new WKTReader2();

    public static synchronized Geometry readGeometry(String wkt, CoordinateReferenceSystem targetCRS) throws Exception {
        String[] wktContents = wkt.split(";");
        Geometry geom = ClipGeometryParser.getGeometry(wktContents[wktContents.length - 1]);
        if (!geom.getClass().isAssignableFrom(Polygon.class) && !geom.getClass().isAssignableFrom(MultiPolygon.class)) {
            throw new ServiceException("Clip must be a polygon or multipolygon", "InvalidParameterValue", "clip");
        }
        CoordinateReferenceSystem geomCRS = null;
        if (wktContents.length == 2 && SRID_REGEX.matcher(wktContents[0].toUpperCase()).matches()) {
            String sridString = wktContents[0].split("=")[1];
            geomCRS = CRS.decode((String)("EPSG:" + sridString), (boolean)true);
            geom.setUserData((Object)geomCRS);
        }
        if (targetCRS != null) {
            if (CRS.getAxisOrder((CoordinateReferenceSystem)targetCRS) == CRS.AxisOrder.NORTH_EAST) {
                String id = ResourcePool.lookupIdentifier(targetCRS, false);
                targetCRS = CRS.decode((String)SrsSyntax.AUTH_CODE.getSRS(id));
            }
            if (geomCRS != null) {
                if (CRS.isTransformationRequired((CoordinateReferenceSystem)targetCRS, geomCRS)) {
                    MathTransform transform = CRS.findMathTransform(geomCRS, (CoordinateReferenceSystem)targetCRS);
                    geom = JTS.transform((Geometry)geom, (MathTransform)transform);
                    geom.setUserData((Object)targetCRS);
                }
            } else {
                geom.setUserData((Object)targetCRS);
            }
        }
        return geom;
    }

    private static Geometry getGeometry(String wkt) {
        try {
            return reader.read(wkt);
        }
        catch (ParseException e) {
            throw new ServiceException("Invalid WKT syntax", "InvalidParameterValue", "clip");
        }
    }
}

