/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.LayerGroupAccessLimits;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.StyleAccessLimits;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.factory.CommonFactoryFinder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.springframework.security.core.Authentication;

public abstract class ResourceAccessManagerWrapper
implements ResourceAccessManager {
    protected ResourceAccessManager delegate;
    private static FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
    private static GeometryFactory geomFactory = new GeometryFactory();

    protected CatalogMode intersection(CatalogMode a, CatalogMode b) {
        if (a == CatalogMode.HIDE || b == CatalogMode.HIDE) {
            return CatalogMode.HIDE;
        }
        if (a == CatalogMode.MIXED || b == CatalogMode.MIXED) {
            return CatalogMode.MIXED;
        }
        if (a == CatalogMode.CHALLENGE || b == CatalogMode.CHALLENGE) {
            return CatalogMode.CHALLENGE;
        }
        return CatalogMode.HIDE;
    }

    protected DataAccessLimits intersection(DataAccessLimits a, DataAccessLimits b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof VectorAccessLimits) {
            VectorAccessLimits limitsa = (VectorAccessLimits)a;
            if (b instanceof VectorAccessLimits) {
                VectorAccessLimits limitsb = (VectorAccessLimits)b;
                return this.intersection(limitsa, limitsb);
            }
        }
        if (a instanceof CoverageAccessLimits) {
            CoverageAccessLimits limitsa = (CoverageAccessLimits)a;
            if (b instanceof CoverageAccessLimits) {
                CoverageAccessLimits limitsb = (CoverageAccessLimits)b;
                return this.intersection(limitsa, limitsb);
            }
        }
        if (a instanceof WMSAccessLimits) {
            WMSAccessLimits limitsa = (WMSAccessLimits)a;
            if (b instanceof WMSAccessLimits) {
                WMSAccessLimits limitsb = (WMSAccessLimits)b;
                return this.intersection(limitsa, limitsb);
            }
        }
        throw new IllegalArgumentException("Tried to get intersection of differing or unanticipated types of DataAccessLimits (" + String.valueOf(a) + " && " + String.valueOf(b) + ")");
    }

    protected VectorAccessLimits intersection(VectorAccessLimits a, VectorAccessLimits b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        CatalogMode mode = this.intersection(a.getMode(), b.getMode());
        List<PropertyName> readAttributes = this.intersection(a.getReadAttributes(), b.getReadAttributes());
        Filter readFilter = this.intersection(a.getReadFilter(), b.getReadFilter());
        List<PropertyName> writeAttributes = this.intersection(a.getReadAttributes(), b.getReadAttributes());
        Filter writeFilter = this.intersection(a.getWriteFilter(), b.getWriteFilter());
        return new VectorAccessLimits(mode, readAttributes, readFilter, writeAttributes, writeFilter);
    }

    protected CoverageAccessLimits intersection(CoverageAccessLimits a, CoverageAccessLimits b) {
        MultiPolygon rasterFilter;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        CatalogMode mode = this.intersection(a.getMode(), b.getMode());
        MultiPolygon aFilter = a.getRasterFilter();
        MultiPolygon bFilter = b.getRasterFilter();
        if (aFilter == null) {
            rasterFilter = bFilter;
        } else if (bFilter == null) {
            rasterFilter = aFilter;
        } else {
            Geometry intersection = aFilter.intersection((Geometry)bFilter);
            if (intersection instanceof MultiPolygon) {
                MultiPolygon polygon1;
                rasterFilter = polygon1 = (MultiPolygon)intersection;
            } else {
                ArrayList accum = new ArrayList();
                intersection.apply(geom -> {
                    if (geom instanceof Polygon) {
                        Polygon polygon = (Polygon)geom;
                        accum.add(polygon);
                    }
                });
                rasterFilter = geomFactory.createMultiPolygon(accum.toArray(new Polygon[accum.size()]));
            }
        }
        Object readFilter = rasterFilter != null && rasterFilter.getNumGeometries() == 0 ? Filter.EXCLUDE : this.intersection(a.getReadFilter(), b.getReadFilter());
        GeneralParameterValue[] params = this.intersection(a.getParams(), b.getParams());
        return new CoverageAccessLimits(mode, (Filter)readFilter, rasterFilter, params);
    }

    protected WMSAccessLimits intersection(WMSAccessLimits a, WMSAccessLimits b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        CatalogMode mode = this.intersection(a.getMode(), b.getMode());
        Filter readFilter = this.intersection(a.getReadFilter(), b.getReadFilter());
        MultiPolygon rasterFilter = null;
        MultiPolygon aFilter = a.getRasterFilter();
        MultiPolygon bFilter = b.getRasterFilter();
        rasterFilter = aFilter == null ? bFilter : (bFilter == null ? aFilter : (MultiPolygon)aFilter.intersection((Geometry)bFilter));
        boolean allowFeatureInfo = a.isAllowFeatureInfo() && b.isAllowFeatureInfo();
        return new WMSAccessLimits(mode, readFilter, rasterFilter, allowFeatureInfo);
    }

    protected Filter intersection(Filter a, Filter b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == Filter.INCLUDE && b == Filter.INCLUDE) {
            return Filter.INCLUDE;
        }
        if (a == Filter.EXCLUDE || b == Filter.EXCLUDE) {
            return Filter.EXCLUDE;
        }
        return factory.and(a, b);
    }

    protected GeneralParameterValue[] intersection(GeneralParameterValue[] a, GeneralParameterValue[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<Integer> indices = new ArrayList<Integer>(Math.min(a.length, b.length));
        List<GeneralParameterValue> bAsList = Arrays.asList(b);
        for (int i = 0; i < a.length; ++i) {
            if (!bAsList.contains(a[i])) continue;
            indices.add(i);
        }
        if (indices.size() == a.length) {
            return a;
        }
        GeneralParameterValue[] results = new GeneralParameterValue[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            results[i] = a[(Integer)indices.get(i)];
        }
        return results;
    }

    protected List<PropertyName> intersection(List<PropertyName> a, List<PropertyName> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<PropertyName> results = new ArrayList<PropertyName>();
        for (PropertyName p : a) {
            if (!b.contains(p)) continue;
            results.add(p);
        }
        return results;
    }

    protected WorkspaceAccessLimits intersection(WorkspaceAccessLimits a, WorkspaceAccessLimits b) {
        CatalogMode mode = this.intersection(a.getMode(), b.getMode());
        return new WorkspaceAccessLimits(mode, a.isReadable() && b.isReadable(), a.isWritable() && b.isWritable(), a.isAdminable() && b.isAdminable());
    }

    public void setDelegate(ResourceAccessManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, ResourceInfo resource) {
        return this.delegate.getAccessLimits(user, resource);
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer) {
        return this.delegate.getAccessLimits(user, layer);
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer, List<LayerGroupInfo> containers) {
        return this.delegate.getAccessLimits(user, layer, containers);
    }

    @Override
    public WorkspaceAccessLimits getAccessLimits(Authentication user, WorkspaceInfo workspace) {
        return this.delegate.getAccessLimits(user, workspace);
    }

    @Override
    public StyleAccessLimits getAccessLimits(Authentication user, StyleInfo style) {
        return this.delegate.getAccessLimits(user, style);
    }

    @Override
    public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerGroup) {
        return this.delegate.getAccessLimits(user, layerGroup);
    }

    @Override
    public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerGroup, List<LayerGroupInfo> containers) {
        return this.delegate.getAccessLimits(user, layerGroup, containers);
    }

    @Override
    public Filter getSecurityFilter(Authentication user, Class<? extends CatalogInfo> clazz) {
        return this.delegate.getSecurityFilter(user, clazz);
    }

    @Override
    public boolean isWorkspaceAdmin(Authentication user, Catalog catalog) {
        return this.delegate.isWorkspaceAdmin(user, catalog);
    }

    public ResourceAccessManager unwrap() {
        return this.delegate;
    }
}

