/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.regex.Pattern;
import org.geoserver.platform.GeoServerExtensions;

public final class CSPUtils {
    public static final String DEFAULT_FALLBACK = "base-uri 'none'; default-src 'none'; form-action 'none'; frame-ancestors 'none';";
    public static final String GEOSERVER_CSP_FALLBACK = "geoserver.csp.fallbackDirectives";
    public static final String GEOSERVER_CSP_REMOTE_RESOURCES = "geoserver.csp.remoteResources";
    public static final String GEOSERVER_CSP_FORM_ACTION = "geoserver.csp.formAction";
    public static final String GEOSERVER_CSP_FRAME_ANCESTORS = "geoserver.csp.frameAncestors";
    public static final Pattern PROPERTY_KEY_REGEX = Pattern.compile("(?i)^[a-z0-9_\\.]*(geoserver|geotools|geowebcache)[a-z0-9_\\.]*$");
    public static final Pattern PROPERTY_VALUE_REGEX = Pattern.compile("(?i)^[a-z0-9'\\*][a-z0-9_\\-':/\\.\\* ]*$");
    private static final Pattern WHITESPACE_REGEX = Pattern.compile("\\s+");

    private CSPUtils() {
    }

    public static String cleanDirectives(String directives) {
        return (directives = WHITESPACE_REGEX.matcher(directives).replaceAll(" ").replace(" ;", ";")).endsWith(";") ? directives : directives + ";";
    }

    public static String getStringProperty(String key, String defaultValue) {
        return Optional.ofNullable(GeoServerExtensions.getProperty((String)key)).map(String::trim).map(Strings::emptyToNull).orElse(defaultValue);
    }

    public static String trimWhitespace(String value) {
        return value != null ? value.trim() : "";
    }
}

