/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp.predicate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.security.csp.CSPHttpRequestWrapper;
import org.geoserver.security.csp.predicate.CSPPredicate;

public class CSPPredicateParameter
implements CSPPredicate {
    private final Pattern keyRegex;
    private final Pattern valueRegex;

    public CSPPredicateParameter(String keyRegex, String valueRegex) {
        this.keyRegex = Pattern.compile(keyRegex);
        this.valueRegex = Pattern.compile(valueRegex);
    }

    @Override
    public boolean test(CSPHttpRequestWrapper request) {
        return this.getQueryParameters(request).allMatch(value -> this.valueRegex.matcher((CharSequence)value).matches());
    }

    private Stream<String> getQueryParameters(CSPHttpRequestWrapper request) {
        List values = request.getParameterMap().entrySet().stream().filter(e -> this.keyRegex.matcher((CharSequence)e.getKey()).matches()).map(Map.Entry::getValue).flatMap(Arrays::stream).collect(Collectors.toList());
        return values.isEmpty() ? Stream.of("") : values.stream();
    }
}

