/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.logging.Logger;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.util.logging.Logging;

public class SecuredFeatureCollection<T extends FeatureType, F extends Feature>
extends DecoratingFeatureCollection<T, F> {
    static final Logger LOGGER = Logging.getLogger(SecuredFeatureCollection.class);
    WrapperPolicy policy;

    SecuredFeatureCollection(FeatureCollection<T, F> delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    public FeatureIterator<F> features() {
        return SecuredObjects.secure(this.delegate.features(), this.policy);
    }

    public FeatureCollection<T, F> sort(SortBy order) {
        FeatureCollection fc = this.delegate.sort(order);
        if (fc == null) {
            return null;
        }
        return SecuredObjects.secure(fc, this.policy);
    }

    public FeatureCollection<T, F> subCollection(Filter filter) {
        FeatureCollection fc = this.delegate.subCollection(filter);
        if (fc == null) {
            return null;
        }
        return SecuredObjects.secure(fc, this.policy);
    }
}

