/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.ProgressListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.factory.Hints;

public class SecuredFeatureTypeInfo
extends DecoratingFeatureTypeInfo {
    protected static final String GET_CAPABILITIES = "GetCapabilities";
    WrapperPolicy policy;

    public SecuredFeatureTypeInfo(FeatureTypeInfo info, WrapperPolicy policy) {
        super(info);
        this.policy = policy;
    }

    @Override
    public FeatureType getFeatureType() throws IOException {
        FeatureType ft = super.getFeatureType();
        if (this.policy.getLimits() == null) {
            return ft;
        }
        if (this.policy.getLimits() instanceof VectorAccessLimits) {
            VectorAccessLimits val = (VectorAccessLimits)this.policy.getLimits();
            Query query = val.getReadQuery();
            if (query.getPropertyNames() == Query.ALL_NAMES) {
                return ft;
            }
            if (ft instanceof SimpleFeatureType) {
                SimpleFeatureType sft = (SimpleFeatureType)ft;
                HashSet<String> properties = new HashSet<String>(Arrays.asList(query.getPropertyNames()));
                SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
                tb.init(sft);
                for (AttributeDescriptor at : sft.getAttributeDescriptors()) {
                    String attName = at.getLocalName();
                    if (properties.contains(attName)) continue;
                    tb.remove(attName);
                }
                return tb.buildFeatureType();
            }
            query.setFilter((Filter)Filter.EXCLUDE);
            FeatureSource<? extends FeatureType, ? extends Feature> fs = this.getFeatureSource(null, null);
            FeatureCollection fc = fs.getFeatures(query);
            return fc.getSchema();
        }
        throw new IllegalArgumentException("SecureFeatureSources has been fed with unexpected AccessLimits class " + String.valueOf(this.policy.getLimits().getClass()));
    }

    @Override
    public FeatureSource<? extends FeatureType, ? extends Feature> getFeatureSource(ProgressListener listener, Hints hints) throws IOException {
        FeatureSource<? extends FeatureType, ? extends Feature> fs = ((FeatureTypeInfo)this.delegate).getFeatureSource(listener, hints);
        Request request = (Request)Dispatcher.REQUEST.get();
        if (this.policy.level == AccessLevel.METADATA && !this.isGetCapabilities(request)) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        return SecuredObjects.secure(fs, this.computeWrapperPolicy(request));
    }

    private WrapperPolicy computeWrapperPolicy(Request request) {
        if (this.isGetCapabilities(request) && this.policy.getLimits() instanceof VectorAccessLimits) {
            VectorAccessLimits accessLimits = (VectorAccessLimits)this.policy.getLimits();
            VectorAccessLimits newLimits = (VectorAccessLimits)accessLimits.clone();
            newLimits.setReadAttributes(null);
            newLimits.setReadFilter((Filter)Filter.INCLUDE);
            WrapperPolicy newPolicy = WrapperPolicy.readOnlyChallenge(newLimits);
            return newPolicy;
        }
        return this.policy;
    }

    private boolean isGetCapabilities(Request request) {
        if (request == null) {
            return false;
        }
        return GET_CAPABILITIES.equalsIgnoreCase(request.getRequest());
    }

    @Override
    public DataStoreInfo getStore() {
        return SecuredObjects.secure(((FeatureTypeInfo)this.delegate).getStore(), this.policy);
    }

    @Override
    public void setStore(StoreInfo store) {
        super.setStore((StoreInfo)SecureCatalogImpl.unwrap((Object)store));
    }

    @Override
    public InternationalString getInternationalTitle() {
        return ((FeatureTypeInfo)this.delegate).getInternationalTitle();
    }

    @Override
    public void setInternationalTitle(InternationalString internationalTitle) {
        ((FeatureTypeInfo)this.delegate).setInternationalTitle(internationalTitle);
    }

    @Override
    public InternationalString getInternationalAbstract() {
        return ((FeatureTypeInfo)this.delegate).getInternationalAbstract();
    }

    @Override
    public void setInternationalAbstract(InternationalString internationalAbstract) {
        ((FeatureTypeInfo)this.delegate).setInternationalAbstract(internationalAbstract);
    }
}

