/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.geoserver.security.Response;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.SecurityUtils;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredFeatureLocking;
import org.geotools.api.data.FeatureLocking;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureLocking;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;

public class SecuredSimpleFeatureLocking
extends SecuredFeatureLocking<SimpleFeatureType, SimpleFeature>
implements SimpleFeatureLocking {
    protected SecuredSimpleFeatureLocking(FeatureLocking<SimpleFeatureType, SimpleFeature> delegate, WrapperPolicy policy) {
        super(delegate, policy);
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return DataUtilities.simple(super.getFeatures());
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return DataUtilities.simple(super.getFeatures(filter));
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        return DataUtilities.simple(super.getFeatures(query));
    }

    public void modifyFeatures(String name, Object attributeValue, Filter filter) throws IOException {
        this.modifyFeatures(new String[]{name}, new Object[]{attributeValue}, filter);
    }

    public void modifyFeatures(String[] names, Object[] values, Filter filter) throws IOException {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        if (writeQuery == Query.ALL) {
            ((SimpleFeatureStore)this.storeDelegate).modifyFeatures(names, values, filter);
        } else if (writeQuery.getFilter() == Filter.EXCLUDE || writeQuery.getPropertyNames() == Query.NO_NAMES) {
            throw this.unsupportedOperation();
        }
        Query local = new Query(null, filter);
        Query mixed = this.mixQueries(local, writeQuery);
        if (writeQuery.getPropertyNames() == Query.ALL_NAMES) {
            ((SimpleFeatureStore)this.storeDelegate).modifyFeatures(names, values, mixed.getFilter());
        } else {
            HashSet<String> queryNames = new HashSet<String>(Arrays.asList(writeQuery.getPropertyNames()));
            for (String name : names) {
                if (queryNames.contains(name)) continue;
                String typeName = ((SimpleFeatureType)this.getSchema()).getName().getLocalPart();
                if (this.policy.getResponse() == Response.CHALLENGE) {
                    throw SecureCatalogImpl.unauthorizedAccess(typeName);
                }
                throw new UnsupportedOperationException("Trying to write on the write protected attribute " + name);
            }
            ((SimpleFeatureStore)this.storeDelegate).modifyFeatures(names, values, mixed.getFilter());
        }
    }
}

