/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingStructuredGridCoverage2DReader;
import org.geoserver.security.decorators.SecuredGridCoverage2DReader;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;

public class SecuredStructuredGridCoverage2DReader
extends DecoratingStructuredGridCoverage2DReader {
    WrapperPolicy policy;

    public SecuredStructuredGridCoverage2DReader(StructuredGridCoverage2DReader delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public Format getFormat() {
        Format format = this.delegate.getFormat();
        if (format == null) {
            return null;
        }
        return SecuredObjects.secure(format, this.policy);
    }

    @Override
    public GridCoverage2D read(GeneralParameterValue ... parameters) throws IllegalArgumentException, IOException {
        return SecuredGridCoverage2DReader.read((GridCoverage2DReader)this.delegate, this.policy, parameters);
    }

    public ServiceInfo getInfo() {
        ServiceInfo info = this.delegate.getInfo();
        if (info == null) {
            return null;
        }
        return SecuredObjects.secure(info, this.policy);
    }

    public ResourceInfo getInfo(String coverageName) {
        ResourceInfo info = this.delegate.getInfo(coverageName);
        if (info == null) {
            return null;
        }
        return SecuredObjects.secure(info, this.policy);
    }
}

